/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import com.nokia.widgets.text.IntegerDocument;
import com.nokia.widgets.text.LongDocument;
import com.nokia.widgets.text.NumberRangeValidator;
import com.nokia.widgets.text.PValidationEvent;
import com.nokia.widgets.text.PValidationException;
import com.nokia.widgets.util.WidgetResources;
import java.math.BigDecimal;
import java.text.MessageFormat;
import javax.swing.text.BadLocationException;

public class DiscontinuousNumberRangeValidator
extends NumberRangeValidator {
    protected double myStep;
    protected int myMaxDecimals = -1;

    public DiscontinuousNumberRangeValidator(double minValue, double maxValue, double step) {
        super(minValue, maxValue);
        if (BigDecimal.valueOf(step).compareTo(BigDecimal.ZERO) == 0) {
            throw new IllegalArgumentException("The step cannot be zero.");
        }
        this.myStep = step;
    }

    public DiscontinuousNumberRangeValidator(double minValue, double maxValue, double step, int maxDecimals) {
        this(minValue, maxValue, step);
        this.myMaxDecimals = maxDecimals;
    }

    public void setStep(double step) {
        this.myStep = step;
    }

    public void setMaxDecimals(int maxDecimals) {
        this.myMaxDecimals = maxDecimals;
    }

    @Override
    public void validate(PValidationEvent e) throws PValidationException {
        String strText = null;
        try {
            strText = e.getDocument().getText(0, e.getDocument().getLength());
        }
        catch (BadLocationException e1) {
            throw new PValidationException();
        }
        if (strText.trim().length() == 0) {
            return;
        }
        try {
            BigDecimal value = BigDecimal.valueOf(Double.parseDouble(strText));
            BigDecimal diff = value.subtract(BigDecimal.valueOf(this.getMinValue()));
            if (this.isNumberOutOfRange(strText) || diff.remainder(BigDecimal.valueOf(this.myStep)).compareTo(BigDecimal.ZERO) != 0) {
                String message = WidgetResources.getString("OutOfDiscontinousRange_Text");
                if (e.getDocument() != null && (e.getDocument() instanceof IntegerDocument || e.getDocument() instanceof LongDocument)) {
                    message = MessageFormat.format(message, strText, String.valueOf(Math.round(this.getMinValue())), String.valueOf(Math.round(this.getMinValue()) + Math.round(this.myStep)), String.valueOf(Math.round(this.getMaxValue())));
                }
                String stepString = String.valueOf(this.myStep);
                int numDecimalPlacesInStepValue = stepString.substring(stepString.indexOf(".")).length() - 1;
                String minValueString = String.valueOf(this.getMinValue());
                int numDeciamlPlacesInMinValue = minValueString.substring(minValueString.indexOf(".")).length() - 1;
                message = MessageFormat.format(message, strText, minValueString, String.valueOf(new BigDecimal(this.getMinValue() + this.myStep).setScale(Math.max(numDecimalPlacesInStepValue, numDeciamlPlacesInMinValue), 4)), String.valueOf(this.getMaxValue()));
                throw new PValidationException(message);
            }
        }
        catch (NumberFormatException ex) {
            throw new PValidationException();
        }
    }
}

