/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import com.nokia.laf.NetTheme;
import com.nokia.laf.util.TextFieldHandler;
import com.nokia.widgets.icons.PArrowIcon;
import com.nokia.widgets.text.PTextField;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.text.Document;

public class DropdownTextField
extends PTextField {
    private DropdownTextFieldHandler myDropdownHandler = null;
    private JList myList = null;
    private static final PArrowIcon ARROW_ICON = new PArrowIcon(4, 4, NetTheme.getComponentOutlineColor());
    private DropdownCursorHandler myDropdownCursorHandler;
    protected final JPopupMenu myPopup = new JPopupMenu(){

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = DropdownTextField.this.getWidth();
            return dimension;
        }
    };

    public DropdownTextField() {
    }

    public DropdownTextField(int columns) {
        super(columns);
    }

    public DropdownTextField(String text) {
        super(text);
    }

    public DropdownTextField(String text, int columns) {
        super(text, columns);
    }

    public DropdownTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
    }

    public void setList(JList list) {
        this.myList = list;
        this.removeMouseListener(this.myDropdownCursorHandler);
        this.removeMouseMotionListener(this.myDropdownCursorHandler);
        if (this.myDropdownHandler != null) {
            this.myDropdownHandler.uninstallListeners();
            this.myDropdownHandler = null;
        }
        if (this.isDropdownEnabled()) {
            this.myDropdownCursorHandler = new DropdownCursorHandler();
            this.initDropdown(list);
            this.addMouseListener(this.myDropdownCursorHandler);
            this.addMouseMotionListener(this.myDropdownCursorHandler);
            this.myDropdownHandler = new DropdownTextFieldHandler(this, this.myList, this.myPopup);
            this.myDropdownHandler.installListeners();
        }
        this.revalidate();
        this.repaint();
    }

    public JList getList() {
        return this.myList;
    }

    public Object getSelectedValue() {
        return this.myList.getSelectedValue();
    }

    private void initDropdown(JList list) {
        this.putClientProperty("OceanTouch.searchDropdown", true);
        JScrollPane scrollPane = new JScrollPane(this.myList, 20, 31);
        scrollPane.setBorder(null);
        list.setFocusable(false);
        this.myPopup.add(scrollPane);
        this.myPopup.setFocusable(false);
        this.myPopup.setBorder(BorderFactory.createEmptyBorder());
    }

    public boolean isDropdownEnabled() {
        if (this.myList == null) {
            return false;
        }
        return this.myList.getModel().getSize() > 0;
    }

    private void showDropdownTextFieldList() {
        DefaultListModel model = (DefaultListModel)this.myList.getModel();
        int size = model.size();
        if (size == 0) {
            this.myPopup.setVisible(false);
        } else {
            this.myList.setVisibleRowCount(size < 8 ? size : 8);
            this.myPopup.pack();
            if (!this.myPopup.isShowing()) {
                this.myPopup.show(this, 0, this.getHeight());
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isDropdownEnabled()) {
            this.paintIcon(g, this.getArrowIcon(), this.getArrowIconPosition(ARROW_ICON));
        }
    }

    protected boolean isOnDropdownArrow(Point position) {
        if (!this.isDropdownEnabled() || !this.isEnabled() || !this.isEditable() || this.isReadOnly()) {
            return false;
        }
        return position.x > this.getArrowIconPosition((Icon)DropdownTextField.ARROW_ICON).x - 4 && position.x < this.getArrowIconPosition((Icon)DropdownTextField.ARROW_ICON).x + 4;
    }

    private Point getArrowIconPosition(Icon arrowIcon) {
        Dimension size = this.getSize();
        int xLocation = 25;
        int yLocation = (int)size.getHeight() / 2 - arrowIcon.getIconHeight() / 2;
        return new Point(25, yLocation);
    }

    private Icon getArrowIcon() {
        return ARROW_ICON;
    }

    private class DropdownCursorHandler
    extends PTextField.CursorHandler {
        private DropdownCursorHandler() {
            super(DropdownTextField.this);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (DropdownTextField.this.isOnDropdownArrow(e.getPoint())) {
                DropdownTextField.this.showDropdownTextFieldList();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (DropdownTextField.this.isOnDropdownArrow(e.getPoint())) {
                DropdownTextField.this.setCursor(Cursor.getPredefinedCursor(12));
                DropdownTextField.this.repaint();
            }
        }
    }

    private class DropdownTextFieldHandler
    extends TextFieldHandler {
        public DropdownTextFieldHandler(PTextField component, JList list, JPopupMenu popup) {
            super(component, list, popup);
        }

        @Override
        protected KeyAdapter createKeyAdapter() {
            this.myDropdownKeyAdapter = new DropdownListKeyAdapter();
            return this.myDropdownKeyAdapter;
        }

        protected class DropdownListKeyAdapter
        extends TextFieldHandler.DropdownKeyAdapter {
            protected DropdownListKeyAdapter() {
            }

            @Override
            protected void showDropdownList() {
                DropdownTextField.this.showDropdownTextFieldList();
            }
        }
    }
}

