/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import com.nokia.widgets.text.PFixedLengthDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

public class FixedLengthAlphaNumericDocument
extends PFixedLengthDocument {
    private static final long serialVersionUID = 1L;
    private static String LINE_SEPARATOR = System.getProperty("line.separator");
    private boolean myAllowXMLEntities = false;

    public FixedLengthAlphaNumericDocument(int length, boolean allowXMLEntities) {
        super(length);
        this.myAllowXMLEntities = allowXMLEntities;
    }

    public FixedLengthAlphaNumericDocument(int length) {
        super(length);
    }

    @Override
    public void insertString(int offset, String text, AttributeSet attrs) throws BadLocationException {
        String str = text;
        if (str.indexOf(LINE_SEPARATOR) > 0) {
            str = str.replaceAll(LINE_SEPARATOR, "");
        }
        if (str.indexOf(10) > 0) {
            str = str.replaceAll("\n", "");
        }
        int i = 0;
        while (i < str.length()) {
            if (!this.isAllowedChar(str.charAt(i))) {
                this.notifyError();
                return;
            }
            ++i;
        }
        super.insertString(offset, str, attrs);
    }

    public boolean isAllowedChar(char ch) {
        if (this.myAllowXMLEntities) {
            return ch >= ' ' && ch <= '~';
        }
        return ch >= ' ' && ch <= '~' && ch != '&' && ch != '<' && ch != '>';
    }
}

