/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import com.nokia.laf.util.TextFieldHandler;
import com.nokia.widgets.text.PTextField;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class HistoryTextField
extends PTextField {
    private HistoryTextFieldHandler myHistoryTextFieldHandler;
    protected transient DocumentListener myDocListener;
    protected int myVisibleRowCount = 8;
    protected final List myHistoryList = new ArrayList();
    protected final JPopupMenu popup = new JPopupMenu(){

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = HistoryTextField.this.getWidth();
            return dimension;
        }
    };
    protected final JList list = new JList(new DefaultListModel());
    protected String myUserText;
    protected boolean notificationDenied;
    protected boolean mySortHistrory = true;

    public HistoryTextField(List history) {
        this();
        this.setHistory(history);
    }

    public HistoryTextField() {
        JScrollPane scrollPane = new JScrollPane(this.list, 20, 31);
        scrollPane.setBorder(null);
        this.list.setFocusable(false);
        this.popup.add(scrollPane);
        this.popup.setFocusable(false);
        this.popup.setBorder(BorderFactory.createEmptyBorder());
        this.myDocListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                HistoryTextField.this.validatePopupOnTextChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                HistoryTextField.this.validatePopupOnTextChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                HistoryTextField.this.validatePopupOnTextChange();
            }
        };
        this.myHistoryTextFieldHandler = new HistoryTextFieldHandler(this, this.list, this.popup);
        this.myHistoryTextFieldHandler.installListeners();
    }

    protected void setHistoryTextWithoutNotification(String text) {
        this.notificationDenied = true;
        try {
            this.setText(text);
        }
        finally {
            this.notificationDenied = false;
        }
    }

    @Override
    public void setDocument(Document doc) {
        if (this.getDocument() != null) {
            this.getDocument().removeDocumentListener(this.myDocListener);
        }
        super.setDocument(doc);
        doc.addDocumentListener(this.myDocListener);
    }

    protected void validatePopupOnTextChange() {
        if (!this.notificationDenied) {
            this.myUserText = this.getText();
            this.showFilteredHistory();
        }
    }

    protected void showFilteredHistory() {
        this.list.getSelectionModel().clearSelection();
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        model.clear();
        int i = 0;
        while (i < this.myHistoryList.size()) {
            String s = (String)this.myHistoryList.get(i);
            if (s.startsWith(this.myUserText)) {
                model.addElement(s);
            }
            ++i;
        }
        int size = model.size();
        if (size == 0) {
            this.popup.setVisible(false);
        } else {
            this.list.setVisibleRowCount(size < this.myVisibleRowCount ? size : this.myVisibleRowCount);
            this.popup.pack();
            if (!this.popup.isShowing()) {
                this.popup.show(this, 0, this.getHeight());
            }
        }
    }

    public String getHistoryUserText() {
        return this.myUserText;
    }

    public void setHistoryUserText(String text) {
        this.myUserText = text;
    }

    public void setVisibleRowCount(int visibleRowCount) {
        this.myVisibleRowCount = visibleRowCount;
    }

    public void setHistorySorted(boolean sorted) {
        this.mySortHistrory = sorted;
    }

    public boolean isHistorySorted() {
        return this.mySortHistrory;
    }

    public List getHistory() {
        return Collections.unmodifiableList(this.myHistoryList);
    }

    public void setHistory(List history) {
        this.myHistoryList.clear();
        this.myHistoryList.addAll(history);
        if (this.mySortHistrory) {
            Collections.sort(this.myHistoryList);
        }
    }

    public void addHistoryItem(String newHistoryItem) {
        this.myHistoryList.add(newHistoryItem);
        if (this.mySortHistrory) {
            Collections.sort(this.myHistoryList);
        }
    }

    private class HistoryTextFieldHandler
    extends TextFieldHandler {
        private HistoryTextField myComponent;

        public HistoryTextFieldHandler(PTextField component, JList list, JPopupMenu popup) {
            super(component, list, popup);
            this.myComponent = (HistoryTextField)component;
        }

        @Override
        protected KeyAdapter createKeyAdapter() {
            this.myDropdownKeyAdapter = new HistoryListKeyAdapter();
            return this.myDropdownKeyAdapter;
        }

        @Override
        protected void setTextWithoutNotification(String selectedValue) {
            this.myComponent.setHistoryTextWithoutNotification(selectedValue);
        }

        protected class HistoryListKeyAdapter
        extends TextFieldHandler.DropdownKeyAdapter {
            protected HistoryListKeyAdapter() {
            }

            @Override
            protected String getUserText() {
                return HistoryTextFieldHandler.this.myComponent.getHistoryUserText();
            }

            @Override
            protected void setUserText(String text) {
                HistoryTextFieldHandler.this.myComponent.setHistoryUserText(text);
            }

            @Override
            protected void showDropdownList() {
                HistoryTextFieldHandler.this.myComponent.showFilteredHistory();
            }
        }
    }
}

