/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import com.nokia.widgets.text.DocumentBase;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

public class IntegerDocument
extends DocumentBase {
    protected int myMaxDigits;
    protected int myMaxValue;
    protected int myMinValue;

    public IntegerDocument(int minValue, int maxValue) {
        this.myMaxValue = maxValue;
        this.myMinValue = minValue;
        this.myMaxDigits = this.calculateMaxDigits(this.myMaxValue, this.myMinValue);
    }

    public void setMaxValue(int maxValue) {
        int oldMax = this.myMaxValue;
        this.myMaxValue = maxValue;
        this.myMaxDigits = this.calculateMaxDigits(this.myMaxValue, this.myMinValue);
        this.mySupport.firePropertyChange("maxValue", oldMax, this.myMaxValue);
    }

    public void setMinValue(int minValue) {
        int oldMin = this.myMinValue;
        this.myMinValue = minValue;
        this.myMaxDigits = this.calculateMaxDigits(this.myMaxValue, this.myMinValue);
        this.mySupport.firePropertyChange("minValue", oldMin, this.myMinValue);
    }

    public void setValue(int newValue) {
        try {
            this.remove(0, this.getLength());
            this.insertString(0, String.valueOf(newValue), null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public int getValue() {
        try {
            return Integer.parseInt(this.getText(0, this.getLength()));
        }
        catch (BadLocationException e) {
            throw new NumberFormatException("Parsing to ineger failed to BadLocationException");
        }
        catch (NumberFormatException e2) {
            throw e2;
        }
    }

    protected int calculateMaxDigits(int minValue, int maxValue) {
        int bigger = Math.max(Math.abs(minValue), Math.abs(maxValue));
        return String.valueOf(bigger).length();
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        StringBuffer builder = new StringBuffer(this.getText(0, this.getLength()));
        String total = builder.insert(offs, str).toString();
        if (!total.equals("-")) {
            int value;
            if (total.startsWith("-") && this.myMinValue >= 0) {
                this.notifyError();
                return;
            }
            if (total.startsWith("+")) {
                this.notifyError();
                return;
            }
            try {
                value = Integer.parseInt(total);
            }
            catch (NumberFormatException e) {
                this.notifyError();
                return;
            }
            if (value < 0) {
                total = total.substring(1);
            }
            if (total.length() > this.myMaxDigits || this.myMaxValue >= 0 && value > this.myMaxValue || this.myMaxValue < 0 && value >= 0 || this.myMinValue <= 0 && value < this.myMinValue || this.myMinValue > 0 && value <= 0 || this.myMaxDigits == 1 && this.myMinValue >= 0 && value < this.myMinValue) {
                this.notifyError();
                return;
            }
        } else if (this.myMinValue >= 0) {
            this.notifyError();
            return;
        }
        super.insertString(offs, str, a);
    }
}

