/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import com.nokia.widgets.text.PValidationEvent;
import com.nokia.widgets.text.PValidationException;
import com.nokia.widgets.text.PValidationListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;

public class IntegerListValidator
implements PValidationListener {
    private List myValidValues;

    public IntegerListValidator(List validValues) {
        this.checkListValidity(validValues);
        this.myValidValues = validValues;
    }

    public IntegerListValidator(int[] validValues) {
        this.myValidValues = IntegerListValidator.asIntegerList(validValues);
    }

    public void setValues(List validValues) {
        this.checkListValidity(validValues);
        this.myValidValues = validValues;
    }

    public List getValues() {
        return this.myValidValues;
    }

    protected void checkListValidity(List values) {
        if (values != null) {
            for (Object value : values) {
                if (value instanceof Integer) continue;
                throw new IllegalArgumentException("The '" + value + "' is not instance of Integer.");
            }
        }
    }

    @Override
    public void validate(PValidationEvent e) throws PValidationException {
        String strText = "";
        try {
            strText = e.getDocument().getText(0, e.getDocument().getLength());
        }
        catch (BadLocationException ble) {
            throw new PValidationException();
        }
        if (strText.trim().length() == 0) {
            return;
        }
        try {
            Integer value = Integer.valueOf(strText);
            if (!this.myValidValues.contains(value)) {
                throw new PValidationException();
            }
        }
        catch (NumberFormatException ex) {
            throw new PValidationException();
        }
    }

    private static List<Integer> asIntegerList(int[] values) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int idx = 0;
        while (idx < values.length) {
            result.add(values[idx]);
            ++idx;
        }
        return result;
    }
}

