/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import com.nokia.widgets.text.DocumentBase;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

public class LongDocument
extends DocumentBase {
    protected int myMaxDigits;
    protected long myMaxValue;
    protected long myMinValue;
    protected boolean myAcceptFullwidthCharacters;

    public LongDocument(long minValue, long maxValue) {
        this(minValue, maxValue, true);
    }

    public LongDocument(long minValue, long maxValue, boolean acceptFullwidthCharacters) {
        this.myAcceptFullwidthCharacters = acceptFullwidthCharacters;
        this.myMaxValue = maxValue;
        this.myMinValue = minValue;
        this.myMaxDigits = this.calculateMaxDigits(this.myMaxValue, this.myMinValue);
    }

    public void setMaxValue(long maxValue) {
        long oldMax = this.myMaxValue;
        this.myMaxValue = maxValue;
        this.myMaxDigits = this.calculateMaxDigits(this.myMaxValue, this.myMinValue);
        this.mySupport.firePropertyChange("maxValue", oldMax, this.myMaxValue);
    }

    public void setMinValue(long minValue) {
        long oldMin = this.myMinValue;
        this.myMinValue = minValue;
        this.myMaxDigits = this.calculateMaxDigits(this.myMaxValue, this.myMinValue);
        this.mySupport.firePropertyChange("minValue", oldMin, this.myMinValue);
    }

    public void setValue(long newValue) {
        try {
            this.remove(0, this.getLength());
            this.insertString(0, String.valueOf(newValue), null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public long getValue() {
        try {
            return Long.parseLong(this.getText(0, this.getLength()));
        }
        catch (BadLocationException e) {
            throw new NumberFormatException("Parsing to long failed to BadLocationException");
        }
        catch (NumberFormatException e2) {
            throw e2;
        }
    }

    protected int calculateMaxDigits(long minValue, long maxValue) {
        long bigger = Math.max(Math.abs(minValue), Math.abs(maxValue));
        return String.valueOf(bigger).length();
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        StringBuffer builder = new StringBuffer(this.getText(0, this.getLength()));
        String total = builder.insert(offs, str).toString();
        if (!total.equals("-")) {
            long value;
            if (total.startsWith("-") && this.myMinValue >= 0L) {
                this.notifyError();
                return;
            }
            if (!this.myAcceptFullwidthCharacters && this.hasFullWidthChar(total)) {
                this.notifyError();
                return;
            }
            try {
                value = Long.parseLong(total);
            }
            catch (NumberFormatException e) {
                this.notifyError();
                return;
            }
            if (value < 0L) {
                total = total.substring(1);
            }
            if (total.length() > this.myMaxDigits || this.myMaxValue >= 0L && value > this.myMaxValue || this.myMaxValue < 0L && value >= 0L || this.myMinValue <= 0L && value < this.myMinValue || this.myMinValue > 0L && value <= 0L) {
                this.notifyError();
                return;
            }
        } else if (this.myMinValue >= 0L) {
            this.notifyError();
            return;
        }
        super.insertString(offs, str, a);
    }

    private boolean hasFullWidthChar(String strValue) {
        char[] cArray = strValue.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if ((c & 0xFF00) == 65280) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

