/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import com.nokia.widgets.text.DocumentBase;
import java.io.UnsupportedEncodingException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

public class MultiLanguageTextAreaDocument
extends DocumentBase {
    protected int myMaxLength;
    protected boolean myAllowXMLEntities;

    public MultiLanguageTextAreaDocument(int intMaxLength) {
        this.setMaxLength(intMaxLength);
    }

    public MultiLanguageTextAreaDocument(int intMaxLength, boolean allowXMLEntities) {
        this.myAllowXMLEntities = allowXMLEntities;
        this.setMaxLength(intMaxLength);
    }

    public void setMaxLength(int intMaxLength) {
        this.myMaxLength = intMaxLength;
    }

    public boolean isAllowedString(String checkedString) {
        return this.myAllowXMLEntities || !checkedString.contains("&") && !checkedString.contains("<") && !checkedString.contains(">");
    }

    @Override
    public void insertString(int offs, String text, AttributeSet a) throws BadLocationException {
        String str = text;
        StringBuffer builder = new StringBuffer(this.getText(0, this.getLength()));
        String total = builder.insert(offs, str).toString();
        if (MultiLanguageTextAreaDocument.getCharacterNumber(total) > this.myMaxLength) {
            this.notifyError();
            return;
        }
        if (!this.isAllowedString(str)) {
            this.notifyError();
            return;
        }
        super.insertString(offs, str, a);
    }

    public static int getCharacterNumber(String str) {
        try {
            return str.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            return str.length();
        }
    }
}

