/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import com.nokia.widgets.text.DocumentBase;
import com.nokia.widgets.text.MultiLanguageTextField;
import java.io.UnsupportedEncodingException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

public class MultiLanguageTextFieldDocument
extends DocumentBase {
    protected int myMaxLength;
    protected boolean myAllowXMLEntities;
    protected MultiLanguageTextField myTextField;

    public MultiLanguageTextFieldDocument(int intMaxLength, MultiLanguageTextField textField) {
        this.setMaxLength(intMaxLength);
        this.myTextField = textField;
    }

    public MultiLanguageTextFieldDocument(int intMaxLength, boolean allowXMLEntities, MultiLanguageTextField textField) {
        this.myAllowXMLEntities = allowXMLEntities;
        this.setMaxLength(intMaxLength);
        this.myTextField = textField;
    }

    public void setMaxLength(int intMaxLength) {
        this.myMaxLength = intMaxLength;
    }

    public boolean isAllowedString(String checkedString) {
        return this.myAllowXMLEntities || !checkedString.contains("&") && !checkedString.contains("<") && !checkedString.contains(">");
    }

    @Override
    public void insertString(int offs, String text, AttributeSet a) throws BadLocationException {
        String str = text;
        if (this.isInvalidCommitInputLength(offs, str) || this.isInvalidNormalInputLength(offs, str)) {
            this.notifyError();
            return;
        }
        if (!this.isAllowedString(str)) {
            this.notifyError();
            return;
        }
        super.insertString(offs, str, a);
    }

    private boolean isInvalidCommitInputLength(int offs, String str) throws BadLocationException {
        StringBuffer builder = new StringBuffer(this.getText(0, this.getLength()));
        String total = builder.insert(offs, str).toString();
        return this.myTextField.isCommitedInput() && this.myTextField.getCommitedInputCount() > 0 && MultiLanguageTextFieldDocument.getCharacterNumber(total) > this.myMaxLength;
    }

    private boolean isInvalidNormalInputLength(int offs, String str) throws BadLocationException {
        StringBuffer builder = new StringBuffer(this.getText(0, this.getLength()));
        String total = builder.insert(offs, str).toString();
        return !this.myTextField.isCommitedInput() && MultiLanguageTextFieldDocument.getCharacterNumber(total) > this.myMaxLength;
    }

    public static int getCharacterNumber(String str) {
        try {
            return str.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            return str.length();
        }
    }
}

