/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import com.nokia.widgets.text.IntegerDocument;
import com.nokia.widgets.text.LongDocument;
import com.nokia.widgets.text.PValidationEvent;
import com.nokia.widgets.text.PValidationException;
import com.nokia.widgets.text.PValidationListener;
import com.nokia.widgets.text.utils.NumberUtils;
import com.nokia.widgets.util.WidgetResources;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.text.BadLocationException;

public class NumberRangeValidator
implements PValidationListener,
PropertyChangeListener {
    private double myMinValue = Double.MIN_VALUE;
    private double myMaxValue = Double.MAX_VALUE;

    public NumberRangeValidator(double minValue, double maxValue) {
        this.myMinValue = minValue;
        this.myMaxValue = maxValue;
    }

    public void setMinValue(double minValue) {
        this.myMinValue = minValue;
    }

    public void setMaxValue(double maxValue) {
        this.myMaxValue = maxValue;
    }

    public double getMinValue() {
        return this.myMinValue;
    }

    public double getMaxValue() {
        return this.myMaxValue;
    }

    @Override
    public void validate(PValidationEvent e) throws PValidationException {
        String strText = "";
        try {
            strText = e.getDocument().getText(0, e.getDocument().getLength());
        }
        catch (BadLocationException ble) {
            throw new PValidationException();
        }
        if (strText.trim().length() == 0) {
            return;
        }
        try {
            if (this.isNumberOutOfRange(strText)) {
                String message = WidgetResources.getString("OutOfRange_Text");
                if (e.getDocument() != null && (e.getDocument() instanceof IntegerDocument || e.getDocument() instanceof LongDocument)) {
                    message = MessageFormat.format(message, strText, String.valueOf(Math.round(this.myMinValue)), String.valueOf(Math.round(this.myMaxValue)));
                }
                message = MessageFormat.format(message, strText, String.valueOf(this.myMinValue), String.valueOf(this.myMaxValue));
                throw new PValidationException(message);
            }
        }
        catch (NumberFormatException ex) {
            throw new PValidationException();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        Object value = evt.getNewValue();
        if (value instanceof Number) {
            Double newValue = ((Number)value).doubleValue();
            if ("minValue".equals(propertyName)) {
                this.myMinValue = newValue;
            } else if ("maxValue".equals(propertyName)) {
                this.myMaxValue = newValue;
            }
        }
    }

    protected boolean isNumberOutOfRange(String strText) {
        if (NumberUtils.isNumeric(strText.trim())) {
            double number = Double.parseDouble(strText);
            return number < this.myMinValue || number > this.myMaxValue;
        }
        return true;
    }
}

