/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import com.nokia.widgets.text.DocumentBase;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

public class PFixedLengthDocument
extends DocumentBase {
    private int myLength = Integer.MAX_VALUE;

    public PFixedLengthDocument() {
    }

    public PFixedLengthDocument(int length) {
        this.myLength = length;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attrs) throws BadLocationException {
        String tempStr = str;
        int currentLength = this.getLength();
        if (offset > currentLength) {
            currentLength = offset;
        }
        if (currentLength < this.myLength) {
            if (tempStr.length() + currentLength > this.myLength) {
                int freeLength = this.myLength - currentLength;
                tempStr = tempStr.substring(0, freeLength);
            }
            super.insertString(offset, tempStr, attrs);
        } else {
            this.notifyError();
        }
    }

    public void setLength(int length) {
        this.myLength = length;
        int currentLength = this.getLength();
        if (currentLength > this.myLength) {
            try {
                this.remove(this.myLength, currentLength - this.myLength);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void setValue(String newValue) {
        try {
            this.remove(0, this.getLength());
            this.insertString(0, newValue, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public String getValue() {
        String txt;
        try {
            txt = this.getText(0, this.getLength());
        }
        catch (BadLocationException e) {
            txt = null;
        }
        return txt;
    }
}

