/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

class PFlasher
extends Timer {
    private Color myOriginalBackground;
    private Color myOriginalForeground;
    private JComponent myComponent;
    private long myLastTimeFlashed = 0L;
    private boolean myIsRunning = false;

    public PFlasher(JComponent component) {
        this(component, 60);
    }

    public PFlasher(JComponent component, int flashTime) {
        super(flashTime, null);
        this.myComponent = component;
        this.setRepeats(false);
        this.addActionListener(new ColorRestorer());
    }

    public void flash() {
        if ((double)Math.abs(System.currentTimeMillis() - this.myLastTimeFlashed) < 1.2 * (double)this.getDelay()) {
            return;
        }
        this.myLastTimeFlashed = System.currentTimeMillis();
        Color oldBackground = this.myComponent.getBackground();
        Color oldForeground = this.myComponent.getForeground();
        if (oldBackground == null || oldBackground instanceof UIResource) {
            this.myComponent.setBackground(UIManager.getColor("TextField.invalidBackground"));
            this.myComponent.setForeground(UIManager.getColor("TextField.invalidForeground"));
            if (this.myIsRunning) {
                this.restart();
            } else {
                this.setOriginalColors(oldBackground, oldForeground);
                this.myIsRunning = true;
                this.start();
            }
        }
    }

    public void setOriginalColors(Color originalBackground, Color originalForeground) {
        this.myOriginalBackground = originalBackground;
        this.myOriginalForeground = originalForeground;
    }

    private class ColorRestorer
    implements ActionListener {
        private ColorRestorer() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PFlasher.this.myComponent.setBackground(PFlasher.this.myOriginalBackground);
            PFlasher.this.myComponent.setForeground(PFlasher.this.myOriginalForeground);
            PFlasher.this.myIsRunning = false;
        }
    }
}

