/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.text.ErrorReportingDocumentListener;
import com.nokia.widgets.text.PFlasher;
import com.nokia.widgets.text.PTextComponent;
import com.nokia.widgets.text.PValidationListener;
import com.nokia.widgets.text.TextComponentValidationHandler;
import com.nokia.widgets.util.ClientPropertyUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Format;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.AbstractButton;
import javax.swing.JFormattedTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class PFormattedTextField
extends JFormattedTextField
implements PropertyChangeListener,
PTextComponent {
    protected transient DocumentListener myHandler = new UpdateHandler();
    private TextComponentValidationHandler myValidationHandler;
    private PFlasher myFlasher;

    public PFormattedTextField() {
        this.init();
    }

    public PFormattedTextField(Object value) {
        super(value);
        this.init();
    }

    public PFormattedTextField(Format format) {
        super(format);
        this.init();
    }

    public PFormattedTextField(JFormattedTextField.AbstractFormatter formatter) {
        super(formatter);
        this.init();
    }

    public PFormattedTextField(JFormattedTextField.AbstractFormatterFactory factory) {
        super(factory);
        this.init();
    }

    public PFormattedTextField(JFormattedTextField.AbstractFormatterFactory factory, Object currentValue) {
        super(factory, currentValue);
        this.init();
    }

    public void setReadOnly(boolean readOnly) {
        this.putClientProperty("OrangeTouch.readOnly", readOnly);
    }

    public void setPrompt(Object inputHint) {
        this.putClientProperty("OrangeTouch.prompt", inputHint);
    }

    public void setLabel(Object label) {
        this.putClientProperty("OrangeTouch.label", label);
    }

    public boolean isReadOnly() {
        return ClientPropertyUtil.booleanValue(this, "OrangeTouch.readOnly");
    }

    @Override
    public void setMandatoryEntry(boolean mandatory) {
        this.putClientProperty("mandatoryEntry", mandatory);
    }

    @Override
    public boolean isMandatoryEntry() {
        return Boolean.TRUE.equals(this.getClientProperty("mandatoryEntry"));
    }

    public boolean isRequiredButMissing() {
        return Boolean.TRUE.equals(this.getClientProperty("requiredButMissing"));
    }

    public void setFlashUsage(boolean usage) {
        this.putClientProperty("useflash", usage);
    }

    public void setUnmodifiedValue(Object unmodifiedValue) {
        this.putClientProperty("BlueTouch.unmodifiedValue", unmodifiedValue);
    }

    public Object getUnmodifiedValue() {
        return this.getClientProperty("BlueTouch.unmodifiedValue");
    }

    public boolean isModified() {
        return Boolean.TRUE.equals(this.getClientProperty("BlueTouch.isModified"));
    }

    public void setValueComparator(Comparator<?> comparator) {
        this.putClientProperty(ClientProperties.VALUE_COMPARATOR, comparator);
    }

    public boolean isFlashUsed() {
        return Boolean.TRUE.equals(this.getClientProperty("useflash"));
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.getDocument().removeDocumentListener(this.myHandler);
        this.getDocument().addDocumentListener(documentListener);
        this.getDocument().addDocumentListener(this.myHandler);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.getDocument().removeDocumentListener(documentListener);
    }

    @Override
    public void addValidationListener(PValidationListener listener) {
        this.listenerList.add(PValidationListener.class, listener);
        this.fireValidation();
    }

    @Override
    public void removeValidationListener(PValidationListener listener) {
        this.listenerList.remove(PValidationListener.class, listener);
        this.fireValidation();
    }

    public boolean isInvalidEntry() {
        return Boolean.TRUE.equals(this.getClientProperty("invalidEntry"));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("document".equals(propertyName)) {
            Document newDocument = (Document)evt.getNewValue();
            Document oldDocument = (Document)evt.getOldValue();
            oldDocument.removeDocumentListener(this.myHandler);
            newDocument.addDocumentListener(this.myHandler);
        } else if ("mandatoryEntry".equals(propertyName)) {
            Object newValue = evt.getNewValue();
            this.putClientProperty("requiredButMissing", Boolean.TRUE.equals(newValue) && this.isMissing());
        }
    }

    public void setValidateOnFocusLost(boolean validate) {
        this.putClientProperty("TextField.validateOnFocusLost", validate);
    }

    public void setValidateOnFocusLost(boolean validate, AbstractButton[] buttons) {
        this.putClientProperty("TextField.validateOnFocusLost", validate);
        this.putClientProperty("TextField.associatedButtons", Arrays.asList(buttons));
    }

    public boolean isValidateOnFocusLost() {
        return Boolean.TRUE.equals(this.getClientProperty("TextField.validateOnFocusLost"));
    }

    @Override
    public void flashField() {
        this.myFlasher.flash();
    }

    protected void init() {
        this.myValidationHandler = new TextComponentValidationHandler(this);
        this.putClientProperty("OrangeTouch.handler", this.myHandler);
        this.getDocument().addDocumentListener(this.myHandler);
        this.addPropertyChangeListener("document", this);
        this.addPropertyChangeListener("mandatoryEntry", this);
        this.myFlasher = new PFlasher(this);
        this.setFlashUsage(true);
    }

    @Override
    public boolean isMissing() {
        return this.getDocument().getLength() == 0;
    }

    protected void fireValidation() {
        this.myValidationHandler.validate();
    }

    private class UpdateHandler
    implements ErrorReportingDocumentListener {
        private UpdateHandler() {
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
            PFormattedTextField.this.fireValidation();
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            this.changedUpdate(evt);
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            this.changedUpdate(evt);
        }

        @Override
        public void notifyUpdateError() {
            if (PFormattedTextField.this.isFlashUsed()) {
                PFormattedTextField.this.flashField();
            }
        }
    }
}

