/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class PMandatoryStateHandler
implements PropertyChangeListener,
DocumentListener {
    private JTextComponent myTextComponent;

    public PMandatoryStateHandler(JTextComponent textComponent) {
        this.myTextComponent = textComponent;
        this.myTextComponent.addPropertyChangeListener(this);
        this.myTextComponent.getDocument().addDocumentListener(this);
    }

    public boolean isMandatoryEntry() {
        return Boolean.TRUE.equals(this.myTextComponent.getClientProperty("mandatoryEntry"));
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateMissingState();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateMissingState();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("mandatoryEntry")) {
            this.updateMissingState();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateMissingState();
    }

    private void updateMissingState() {
        this.myTextComponent.putClientProperty("requiredButMissing", this.isMandatoryEntry() && this.myTextComponent.getDocument().getLength() == 0);
    }
}

