/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import com.nokia.widgets.text.PFlasher;
import com.nokia.widgets.text.PTextComponent;
import com.nokia.widgets.text.PValidationListener;
import com.nokia.widgets.text.TextComponentValidationHandler;
import com.nokia.widgets.util.ClientPropertyUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class PPasswordField
extends JPasswordField
implements PropertyChangeListener,
PTextComponent {
    protected transient DocumentListener myHandler = new UpdateHandler();
    private TextComponentValidationHandler myValidationHandler;
    private PFlasher myFlasher;

    public PPasswordField() {
        this(null, null, 0);
    }

    public PPasswordField(int columns) {
        this(null, null, columns);
    }

    public PPasswordField(String text) {
        this(null, text, 0);
    }

    public PPasswordField(String text, int columns) {
        this(null, text, columns);
    }

    public PPasswordField(Document doc, String txt, int columns) {
        super(doc, txt, columns);
        this.init();
    }

    public void setSizeVariant(String sizeVariant) {
        this.putClientProperty("JComponent.sizeVariant", sizeVariant);
    }

    public void setReadOnly(boolean readOnly) {
        this.putClientProperty("OrangeTouch.readOnly", readOnly);
    }

    public boolean isReadOnly() {
        return ClientPropertyUtil.booleanValue(this, "OrangeTouch.readOnly");
    }

    public void setValidateOnFocusLost(boolean validate) {
        this.putClientProperty("TextField.validateOnFocusLost", validate);
    }

    public void setValidateOnFocusLost(boolean validate, AbstractButton[] buttons) {
        this.putClientProperty("TextField.validateOnFocusLost", validate);
        this.putClientProperty("TextField.associatedButtons", Arrays.asList(buttons));
    }

    public boolean isValidateOnFocusLost() {
        return Boolean.TRUE.equals(this.getClientProperty("TextField.validateOnFocusLost"));
    }

    @Override
    public void flashField() {
        this.myFlasher.flash();
    }

    @Override
    public void setMandatoryEntry(boolean mandatory) {
        this.putClientProperty("mandatoryEntry", mandatory);
    }

    @Override
    public boolean isMandatoryEntry() {
        return Boolean.TRUE.equals(this.getClientProperty("mandatoryEntry"));
    }

    public boolean isRequiredButMissing() {
        return Boolean.TRUE.equals(this.getClientProperty("requiredButMissing"));
    }

    public boolean isInvalidEntry() {
        return Boolean.TRUE.equals(this.getClientProperty("invalidEntry"));
    }

    public void setPrompt(Object inputHint) {
        this.putClientProperty("OrangeTouch.prompt", inputHint);
    }

    public void setLabel(Object label) {
        this.putClientProperty("OrangeTouch.label", label);
    }

    public void setUnmodifiedValue(Object unmodifiedValue) {
        this.putClientProperty("BlueTouch.unmodifiedValue", unmodifiedValue);
    }

    public void setDisplayValidValue(boolean displayValid) {
        this.putClientProperty("OrangeTouch.displayValidValue", displayValid);
        this.fireValidation();
    }

    public void setDisplayErrorIcon(boolean displayErrorIcon) {
        this.putClientProperty("OrangeTouch.displayErrorIcon", displayErrorIcon);
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.getDocument().removeDocumentListener(this.myHandler);
        this.getDocument().addDocumentListener(documentListener);
        this.getDocument().addDocumentListener(this.myHandler);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.getDocument().removeDocumentListener(documentListener);
    }

    @Override
    public void addValidationListener(PValidationListener listener) {
        this.listenerList.add(PValidationListener.class, listener);
        this.fireValidation();
    }

    @Override
    public void removeValidationListener(PValidationListener listener) {
        this.listenerList.remove(PValidationListener.class, listener);
        this.fireValidation();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("document".equals(propertyName)) {
            Document newDocument = (Document)evt.getNewValue();
            Document oldDocument = (Document)evt.getOldValue();
            oldDocument.removeDocumentListener(this.myHandler);
            newDocument.addDocumentListener(this.myHandler);
        } else if ("mandatoryEntry".equals(propertyName)) {
            Object newValue = evt.getNewValue();
            this.putClientProperty("requiredButMissing", Boolean.TRUE.equals(newValue) && this.isMissing());
        }
    }

    protected void init() {
        this.myValidationHandler = new TextComponentValidationHandler(this);
        this.getDocument().addDocumentListener(this.myHandler);
        this.putClientProperty("OrangeTouch.handler", this.myHandler);
        this.addPropertyChangeListener("document", this);
        this.addPropertyChangeListener("mandatoryEntry", this);
        this.myFlasher = new PFlasher(this);
    }

    protected void fireValidation() {
        this.myValidationHandler.validate();
    }

    @Override
    public boolean isMissing() {
        return this.getDocument().getLength() == 0;
    }

    private class UpdateHandler
    implements DocumentListener {
        private UpdateHandler() {
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
            PPasswordField.this.fireValidation();
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            this.changedUpdate(evt);
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            this.changedUpdate(evt);
        }
    }
}

