/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.search.SearchHelper;
import com.nokia.widgets.text.ErrorReportingDocumentListener;
import com.nokia.widgets.text.PFlasher;
import com.nokia.widgets.util.ClientPropertyUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class PTextArea
extends JTextArea
implements PropertyChangeListener {
    protected DocumentListener myHandler = new UpdateHandler();
    private SearchHelper myHelper;
    private PFlasher myFlasher;

    public PTextArea() {
        this.init();
    }

    public PTextArea(String text) {
        super(text);
        this.init();
    }

    public PTextArea(int rows, int columns) {
        super(rows, columns);
        this.init();
    }

    public PTextArea(String text, int rows, int columns) {
        super(text, rows, columns);
        this.init();
    }

    public PTextArea(Document doc) {
        super(doc);
        this.init();
    }

    public PTextArea(Document doc, String text, int rows, int columns) {
        super(doc, text, rows, columns);
        this.init();
    }

    protected void init() {
        this.myFlasher = new PFlasher(this);
        this.getDocument().addDocumentListener(this.myHandler);
        this.putClientProperty("OrangeTouch.handler", this.myHandler);
        this.addPropertyChangeListener("document", this);
        this.addPropertyChangeListener("mandatoryEntry", this);
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.getDocument().removeDocumentListener(this.myHandler);
        this.getDocument().addDocumentListener(documentListener);
        this.getDocument().addDocumentListener(this.myHandler);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.getDocument().removeDocumentListener(documentListener);
    }

    protected boolean isMissing() {
        return this.getDocument().getLength() == 0;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("document".equals(propertyName)) {
            Document newDocument = (Document)evt.getNewValue();
            Document oldDocument = (Document)evt.getOldValue();
            oldDocument.removeDocumentListener(this.myHandler);
            newDocument.addDocumentListener(this.myHandler);
            this.fireValidation();
        } else if ("mandatoryEntry".equals(propertyName)) {
            Object newValue = evt.getNewValue();
            this.putClientProperty("requiredButMissing", Boolean.TRUE.equals(newValue) && this.isMissing());
        }
    }

    public void setSearchEnabled(boolean canSearch) {
        if (this.myHelper == null) {
            this.myHelper = new SearchHelper(this);
        }
        this.myHelper.enableSearch(canSearch);
    }

    public void setPrompt(Object inputHint) {
        this.putClientProperty("OrangeTouch.prompt", inputHint);
    }

    public void setMandatoryEntry(boolean mandatory) {
        this.putClientProperty("mandatoryEntry", mandatory);
    }

    public boolean isMandatoryEntry() {
        return Boolean.TRUE.equals(this.getClientProperty("mandatoryEntry"));
    }

    public boolean isRequiredButMissing() {
        return Boolean.TRUE.equals(this.getClientProperty("requiredButMissing"));
    }

    public void fireValidation() {
        this.putClientProperty("requiredButMissing", this.isMandatoryEntry() && this.isMissing());
    }

    public boolean isReadOnly() {
        return ClientPropertyUtil.booleanValue(this, "OrangeTouch.readOnly");
    }

    public void setReadOnly(boolean readOnly) {
        this.putClientProperty("OrangeTouch.readOnly", readOnly);
    }

    public void setUnmodifiedValue(Object unmodifiedValue) {
        this.putClientProperty("BlueTouch.unmodifiedValue", unmodifiedValue);
    }

    public Object getUnmodifiedValue() {
        return this.getClientProperty("BlueTouch.unmodifiedValue");
    }

    public boolean isModified() {
        return Boolean.TRUE.equals(this.getClientProperty("BlueTouch.isModified"));
    }

    public void setValueComparator(Comparator<?> comparator) {
        this.putClientProperty(ClientProperties.VALUE_COMPARATOR, comparator);
    }

    public boolean isFlashUsed() {
        return Boolean.TRUE.equals(this.getClientProperty("useflash"));
    }

    public void flashField() {
        if (this.isFlashUsed()) {
            this.myFlasher.flash();
        }
    }

    private class UpdateHandler
    implements ErrorReportingDocumentListener {
        private UpdateHandler() {
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
            PTextArea.this.fireValidation();
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            this.changedUpdate(evt);
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            this.changedUpdate(evt);
        }

        @Override
        public void notifyUpdateError() {
            PTextArea.this.flashField();
        }
    }
}

