/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.text.ErrorReportingDocumentListener;
import com.nokia.widgets.text.PFlasher;
import com.nokia.widgets.text.PTextComponent;
import com.nokia.widgets.text.PValidationListener;
import com.nokia.widgets.text.TextComponentValidationHandler;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ColorProvider;
import com.nokia.widgets.util.ComponentUtils;
import com.nokia.widgets.util.ImageUtils;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class PTextField
extends JTextField
implements PropertyChangeListener,
PTextComponent {
    private static final ImageIcon FOCUSED_CLEAR_ICON = CommonIcons.getCancelIcon();
    private static final ImageIcon CLEAR_ICON = new ImageIcon(ImageUtils.createSolidColorImage(FOCUSED_CLEAR_ICON.getImage(), ColorProvider.getColor("TextField.clearButtonColor", "TextField.foreground")));
    private static final ImageIcon HOVERED_CLEAR_ICON = new ImageIcon(ImageUtils.createRolloverImage(CLEAR_ICON.getImage()));
    protected DocumentListener myHandler = new UpdateHandler();
    private boolean myClearable;
    protected CursorHandler myCursorHandler;
    private TextComponentValidationHandler myValidationHandler;
    private PFlasher myFlasher;

    public PTextField() {
        this(null, null, 0);
    }

    public PTextField(int columns) {
        this(null, null, columns);
    }

    public PTextField(String text) {
        this(null, text, 0);
    }

    public PTextField(String text, int columns) {
        this(null, text, columns);
    }

    public PTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.init();
    }

    public void setSearchField(boolean searchField) {
        this.putClientProperty("OrangeTouch.searchField", searchField);
        this.setClearable(true);
        this.setLabel(WidgetResources.getString("Search_Text"));
    }

    public void useFilterIconInSearchField() {
        this.putClientProperty("OrangeTouch.useFilterIconInSearchField", true);
    }

    public boolean isSearchField() {
        return ClientPropertyUtil.booleanValue(this, "OrangeTouch.searchField");
    }

    public void setClearable(boolean clearable) {
        if (clearable == this.isClearable()) {
            return;
        }
        if (clearable) {
            ToolTipManager.sharedInstance().registerComponent(this);
            this.myCursorHandler = new CursorHandler();
            this.addMouseListener(this.myCursorHandler);
            this.addMouseMotionListener(this.myCursorHandler);
        } else {
            this.removeMouseListener(this.myCursorHandler);
            this.removeMouseMotionListener(this.myCursorHandler);
            this.myCursorHandler = null;
            this.putClientProperty("OrangeTouch.clearIconHovered", null);
        }
        this.myClearable = clearable;
        this.revalidate();
        this.repaint();
    }

    public boolean isClearable() {
        return this.myClearable;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isClearable() && this.getText().length() > 0) {
            this.paintIcon(g, this.getClearIcon(), this.getClearIconPosition(CLEAR_ICON));
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.isOnClearIcon(event.getPoint())) {
            return WidgetResources.getString("ClearButton_TooltipText");
        }
        return super.getToolTipText(event);
    }

    public void setLabel(Object label) {
        this.putClientProperty("OrangeTouch.label", label);
    }

    public void setPrompt(Object prompt) {
        this.putClientProperty("OrangeTouch.prompt", prompt);
    }

    public void setProgressOngoing(boolean progressOngoing) {
        this.putClientProperty("OrangeTouch.progressOngoing", progressOngoing);
    }

    @Override
    public void setMandatoryEntry(boolean mandatory) {
        this.putClientProperty("mandatoryEntry", mandatory);
    }

    @Override
    public boolean isMandatoryEntry() {
        return Boolean.TRUE.equals(this.getClientProperty("mandatoryEntry"));
    }

    public boolean isRequiredButMissing() {
        return Boolean.TRUE.equals(this.getClientProperty("requiredButMissing"));
    }

    public void setReadOnly(boolean readOnly) {
        this.putClientProperty("OrangeTouch.readOnly", readOnly);
    }

    public boolean isReadOnly() {
        return ClientPropertyUtil.booleanValue(this, "OrangeTouch.readOnly");
    }

    public void setUnmodifiedValue(Object unmodifiedValue) {
        this.putClientProperty("BlueTouch.unmodifiedValue", unmodifiedValue);
    }

    public Object getUnmodifiedValue() {
        return this.getClientProperty("BlueTouch.unmodifiedValue");
    }

    public boolean isModified() {
        return Boolean.TRUE.equals(this.getClientProperty("BlueTouch.isModified"));
    }

    public void setValueComparator(Comparator<?> comparator) {
        this.putClientProperty(ClientProperties.VALUE_COMPARATOR, comparator);
    }

    public void setDisplayValidValue(boolean displayValid) {
        this.putClientProperty("OrangeTouch.displayValidValue", displayValid);
        this.fireValidation();
    }

    public void setDisplayErrorIcon(boolean displayErrorIcon) {
        this.putClientProperty("OrangeTouch.displayErrorIcon", displayErrorIcon);
    }

    @Override
    public void addValidationListener(PValidationListener listener) {
        this.listenerList.add(PValidationListener.class, listener);
        this.fireValidation();
    }

    @Override
    public void removeValidationListener(PValidationListener listener) {
        this.listenerList.remove(PValidationListener.class, listener);
        this.fireValidation();
    }

    public boolean isInvalidEntry() {
        return Boolean.TRUE.equals(this.getClientProperty("invalidEntry"));
    }

    public boolean isInvalidOrMissing() {
        return this.isInvalidEntry() || this.isRequiredButMissing();
    }

    public void setSizeVariant(String sizeVariant) {
        this.putClientProperty("JComponent.sizeVariant", sizeVariant);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("document".equals(propertyName)) {
            Document newDocument = (Document)evt.getNewValue();
            Document oldDocument = (Document)evt.getOldValue();
            oldDocument.removeDocumentListener(this.myHandler);
            newDocument.addDocumentListener(this.myHandler);
            this.fireValidation();
        } else if ("mandatoryEntry".equals(propertyName)) {
            Object newValue = evt.getNewValue();
            this.putClientProperty("requiredButMissing", Boolean.TRUE.equals(newValue) && this.isMissing());
        }
    }

    public void setValidateOnFocusLost(boolean validate, AbstractButton[] buttons) {
        this.putClientProperty("TextField.validateOnFocusLost", validate);
        this.putClientProperty("TextField.associatedButtons", Arrays.asList(buttons));
    }

    public void setValidateOnFocusLost(boolean validate) {
        this.putClientProperty("TextField.validateOnFocusLost", validate);
    }

    public boolean isValidateOnFocusLost() {
        return Boolean.TRUE.equals(this.getClientProperty("TextField.validateOnFocusLost"));
    }

    public void setFlashUsage(boolean usage) {
        this.putClientProperty("useflash", usage);
    }

    public boolean isFlashUsed() {
        return Boolean.TRUE.equals(this.getClientProperty("useflash"));
    }

    @Override
    public void flashField() {
        if (this.isFlashUsed()) {
            this.myFlasher.flash();
        }
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.getDocument().removeDocumentListener(this.myHandler);
        this.getDocument().addDocumentListener(documentListener);
        this.getDocument().addDocumentListener(this.myHandler);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.getDocument().removeDocumentListener(documentListener);
    }

    protected void init() {
        this.myValidationHandler = new TextComponentValidationHandler(this);
        this.getDocument().addDocumentListener(this.myHandler);
        this.putClientProperty("OrangeTouch.handler", this.myHandler);
        this.addPropertyChangeListener("document", this);
        this.addPropertyChangeListener("mandatoryEntry", this);
        this.setValidateOnFocusLost(true);
        this.myFlasher = new PFlasher(this);
        this.setFlashUsage(true);
    }

    @Override
    public boolean isMissing() {
        return this.getDocument().getLength() == 0;
    }

    public void fireValidation() {
        this.myValidationHandler.validate();
    }

    protected boolean isOnClearIcon(Point position) {
        if (!this.isClearable() || !this.isEnabled() || !this.isEditable() || this.isReadOnly() || this.getText().length() == 0) {
            return false;
        }
        return position.x > this.getClearIconPosition((Icon)PTextField.CLEAR_ICON).x - 4;
    }

    protected void paintIcon(Graphics g, Icon icon, Point position) {
        icon.paintIcon(this, g, position.x, position.y);
    }

    private Point getClearIconPosition(Icon clearIcon) {
        int xOffset;
        Dimension size = this.getSize();
        int yOffset = 0;
        boolean small = ComponentUtils.isSmall(this);
        int n = xOffset = small ? 6 : 12;
        if (this.isSearchField()) {
            xOffset = 9;
        } else if (ClientPropertyUtil.booleanValue(this, "OrangeTouch.openRightEdge")) {
            xOffset -= 3;
            yOffset = 1;
        }
        int xLocation = (int)size.getWidth() - clearIcon.getIconWidth() - xOffset;
        int yLocation = (int)size.getHeight() / 2 - clearIcon.getIconHeight() / 2 + yOffset;
        return new Point(xLocation, yLocation);
    }

    private Icon getClearIcon() {
        if (!this.isEnabled() || !this.isEditable() || this.isReadOnly()) {
            return UIManager.getLookAndFeel().getDisabledIcon(this, CLEAR_ICON);
        }
        if (ClientPropertyUtil.booleanValue(this, "OrangeTouch.clearIconHovered")) {
            return HOVERED_CLEAR_ICON;
        }
        if (this.isFocusOwner()) {
            return FOCUSED_CLEAR_ICON;
        }
        return CLEAR_ICON;
    }

    protected class CursorHandler
    extends MouseAdapter
    implements MouseMotionListener {
        protected CursorHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.mouseMoved(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (PTextField.this.isOnClearIcon(e.getPoint())) {
                PTextField.this.setText("");
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            PTextField.this.putClientProperty("OrangeTouch.clearIconHovered", false);
            PTextField.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (PTextField.this.isOnClearIcon(e.getPoint())) {
                PTextField.this.setCursor(Cursor.getPredefinedCursor(12));
                PTextField.this.putClientProperty("OrangeTouch.clearIconHovered", true);
                PTextField.this.repaint();
            } else {
                PTextField.this.setCursor(Cursor.getPredefinedCursor(2));
                PTextField.this.putClientProperty("OrangeTouch.clearIconHovered", false);
                PTextField.this.repaint();
            }
        }
    }

    private class UpdateHandler
    implements ErrorReportingDocumentListener {
        private UpdateHandler() {
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
            PTextField.this.fireValidation();
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            this.changedUpdate(evt);
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            this.changedUpdate(evt);
        }

        @Override
        public void notifyUpdateError() {
            if (PTextField.this.isFlashUsed()) {
                PTextField.this.flashField();
            }
        }
    }
}

