/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.infotip.InfoTip;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.text.JTextComponent;

class TextComponentBalloonHandler
extends MouseAdapter
implements MouseMotionListener {
    private final JTextComponent myTextComponent;
    private InfoTip myInfoTip;

    public TextComponentBalloonHandler(JTextComponent textComponent, String message) {
        this.myTextComponent = textComponent;
        this.setMessage(message);
    }

    public void setMessage(String message) {
        if (this.myInfoTip != null) {
            this.myInfoTip.setVisible(false);
        }
        this.myInfoTip = new InfoTip((Component)this.myTextComponent, message.toString());
        this.myInfoTip.setDisplayStrategy(3);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.myInfoTip != null) {
            this.myInfoTip.setVisible(false);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.myInfoTip != null) {
            this.myInfoTip.setVisible(false);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        boolean showErrorIcon = ClientPropertyUtil.booleanValue(this.myTextComponent, "OrangeTouch.displayErrorIcon", true);
        if (!showErrorIcon || this.myInfoTip == null || !this.myTextComponent.isEnabled() || this.myInfoTip.isVisible() && this.isOnErrorIcon(e.getPoint())) {
            return;
        }
        if (this.myInfoTip != null && this.isOnErrorIcon(e.getPoint()) && ClientPropertyUtil.booleanValue(this.myTextComponent, "OrangeTouch.displayInvalidEntry") && ComponentUtils.isInvalid(this.myTextComponent) && !NetUtils.isTableEditorTextField(this.myTextComponent)) {
            this.myTextComponent.setCursor(Cursor.getPredefinedCursor(0));
            Insets insets = this.myInfoTip.getInsets();
            this.myInfoTip.setPreferredLocation(new Point(-this.myInfoTip.getPreferredSize().width + this.myTextComponent.getWidth() + insets.left + insets.right + 4, this.myTextComponent.getHeight() + 1));
            this.myInfoTip.setArrowXLocation(this.myTextComponent.getWidth() - 10);
            this.myInfoTip.show();
        } else if (this.myInfoTip != null) {
            this.myInfoTip.setVisible(false);
            this.myTextComponent.setCursor(Cursor.getPredefinedCursor(2));
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    protected boolean isOnErrorIcon(Point position) {
        if (!ComponentUtils.isInvalid(this.myTextComponent)) {
            return false;
        }
        return position.x > this.myTextComponent.getWidth() - this.myTextComponent.getHeight() + 2;
    }
}

