/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import com.nokia.widgets.text.PTextComponent;
import com.nokia.widgets.text.PValidationEvent;
import com.nokia.widgets.text.PValidationException;
import com.nokia.widgets.text.PValidationListener;
import com.nokia.widgets.text.TextComponentBalloonHandler;
import javax.swing.ToolTipManager;
import javax.swing.text.JTextComponent;

public class TextComponentValidationHandler {
    private JTextComponent myTextComponent;
    private TextComponentBalloonHandler myBalloonHandler;

    public TextComponentValidationHandler(JTextComponent textComponent) {
        this.myTextComponent = textComponent;
    }

    public void validate() {
        block4: {
            PValidationListener[] listeners = (PValidationListener[])this.myTextComponent.getListeners(PValidationListener.class);
            try {
                PValidationEvent event = new PValidationEvent(this, this.myTextComponent.getDocument());
                int idx = listeners.length - 1;
                while (idx >= 0) {
                    listeners[idx].validate(event);
                    --idx;
                }
                this.myTextComponent.putClientProperty("invalidEntry", Boolean.FALSE);
            }
            catch (PValidationException e) {
                this.myTextComponent.putClientProperty("invalidEntry", Boolean.TRUE);
                if (e.getMessage() == null) break block4;
                if (this.myBalloonHandler == null) {
                    ToolTipManager.sharedInstance().registerComponent(this.myTextComponent);
                    this.myBalloonHandler = new TextComponentBalloonHandler(this.myTextComponent, e.getMessage());
                    this.myTextComponent.addMouseListener(this.myBalloonHandler);
                    this.myTextComponent.addMouseMotionListener(this.myBalloonHandler);
                }
                this.myBalloonHandler.setMessage(e.getMessage());
            }
        }
        PTextComponent textComponent = (PTextComponent)((Object)this.myTextComponent);
        this.myTextComponent.putClientProperty("requiredButMissing", textComponent.isMandatoryEntry() && textComponent.isMissing());
    }
}

