/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import com.nokia.widgets.text.AlphaNumericDocument;
import com.nokia.widgets.text.DecimalDocument;
import com.nokia.widgets.text.DecimalListValidator;
import com.nokia.widgets.text.DiscontinuousNumberRangeValidator;
import com.nokia.widgets.text.FixedLengthAlphaNumericDocument;
import com.nokia.widgets.text.IntegerDocument;
import com.nokia.widgets.text.IntegerListValidator;
import com.nokia.widgets.text.LongDocument;
import com.nokia.widgets.text.LongListValidator;
import com.nokia.widgets.text.MultiLanguageTextField;
import com.nokia.widgets.text.MultiLanguageTextFieldDocument;
import com.nokia.widgets.text.NumberRangeValidator;
import com.nokia.widgets.text.PFixedLengthDocument;
import com.nokia.widgets.text.PTextField;
import com.nokia.widgets.text.PValidationListener;
import com.nokia.widgets.text.TextFieldValidationUtils;
import com.nokia.widgets.text.UnionValidator;
import java.util.List;

public class TextFieldFactory {
    public static PTextField createDecimalTextField(int maxDecimDigits, double minValue, double maxValue) {
        return TextFieldFactory.createDecimalTextField(maxDecimDigits, minValue, maxValue, null);
    }

    public static PTextField createDecimalTextField(int maxDecimDigits, double minValue, double maxValue, boolean acceptFullwidthCharacters) {
        return TextFieldFactory.createDecimalTextField(maxDecimDigits, minValue, maxValue, null, acceptFullwidthCharacters);
    }

    public static PTextField createDecimalTextField(int maxDecimDigits, double minValue, double maxValue, double[] specialValues) {
        return TextFieldFactory.createDecimalTextField(maxDecimDigits, minValue, maxValue, specialValues, true);
    }

    public static PTextField createDecimalTextField(int maxDecimDigits, double minValue, double maxValue, double[] specialValues, boolean acceptFullWidthCharacter) {
        if (maxDecimDigits == 0) {
            long[] longSpecialValues = TextFieldValidationUtils.convertArrayDoubleToLong(specialValues);
            return TextFieldFactory.createLongTextField((long)minValue, (long)maxValue, longSpecialValues, acceptFullWidthCharacter);
        }
        PTextField txt = TextFieldFactory.createRightAlignedTextField();
        NumberRangeValidator rangeValidator = new NumberRangeValidator(minValue, maxValue);
        if (specialValues != null) {
            TextFieldFactory.initDoubleSpecialValuesValidation(txt, maxDecimDigits, minValue, maxValue, rangeValidator, specialValues);
        } else {
            DecimalDocument doc = new DecimalDocument(maxDecimDigits, minValue, maxValue);
            txt.setDocument(doc);
            doc.addPropertyChangeListener(rangeValidator);
            txt.addValidationListener(rangeValidator);
        }
        txt.enableInputMethods(false);
        txt.setColumns(TextFieldValidationUtils.getColumns(maxDecimDigits, minValue, maxValue, specialValues));
        return txt;
    }

    public static PTextField createDiscontinuousDecimalRangeTextField(int maxDecimDigits, double minValue, double maxValue, double step) {
        return TextFieldFactory.createDiscontinuousDecimalRangeTextField(maxDecimDigits, minValue, maxValue, step, null);
    }

    public static PTextField createDiscontinuousDecimalRangeTextField(int maxDecimDigits, double minValue, double maxValue, double step, double[] specialValues) {
        return TextFieldFactory.createDiscontinuousDecimalRangeTextField(maxDecimDigits, minValue, maxValue, step, specialValues, true);
    }

    public static PTextField createDiscontinuousDecimalRangeTextField(int maxDecimDigits, double minValue, double maxValue, double step, double[] specialValues, boolean acceptFullwidthCharacters) {
        PTextField txt = TextFieldFactory.createRightAlignedTextField();
        if (maxDecimDigits == 0) {
            long[] longSpecialValues = TextFieldValidationUtils.convertArrayDoubleToLong(specialValues);
            return TextFieldFactory.createDiscontinuousLongRangeTextField((long)minValue, (long)maxValue, (long)step, longSpecialValues, acceptFullwidthCharacters);
        }
        DiscontinuousNumberRangeValidator rangeValidator = new DiscontinuousNumberRangeValidator(minValue, maxValue, step, maxDecimDigits);
        if (specialValues != null) {
            TextFieldFactory.initDoubleSpecialValuesValidation(txt, maxDecimDigits, minValue, maxValue, rangeValidator, specialValues);
        } else {
            DecimalDocument doc = new DecimalDocument(maxDecimDigits, minValue, maxValue);
            doc.addPropertyChangeListener(rangeValidator);
            txt.setDocument(doc);
            txt.addValidationListener(rangeValidator);
        }
        txt.setColumns(TextFieldValidationUtils.getColumns(maxDecimDigits, minValue, maxValue, specialValues));
        return txt;
    }

    public static PTextField createIntegerTextField(int minValue, int maxValue) {
        return TextFieldFactory.createIntegerTextField(minValue, maxValue, null);
    }

    public static PTextField createIntegerTextField(int minValue, int maxValue, int[] specialValues) {
        PTextField txt = TextFieldFactory.createRightAlignedTextField();
        NumberRangeValidator rangeValidator = new NumberRangeValidator(minValue, maxValue);
        if (specialValues != null) {
            TextFieldFactory.initIntegerSpecialValuesValidation(txt, minValue, maxValue, rangeValidator, specialValues);
        } else {
            txt.addValidationListener(rangeValidator);
            IntegerDocument doc = new IntegerDocument(minValue, maxValue);
            doc.addPropertyChangeListener(rangeValidator);
            txt.setDocument(doc);
        }
        txt.enableInputMethods(false);
        txt.setColumns(TextFieldValidationUtils.getColumns(minValue, maxValue, specialValues));
        return txt;
    }

    public static PTextField createDiscontinuousIntegerRangeTextField(int minValue, int maxValue, int step) {
        return TextFieldFactory.createDiscontinuousIntegerRangeTextField(minValue, maxValue, step, null);
    }

    public static PTextField createDiscontinuousIntegerRangeTextField(int minValue, int maxValue, int step, int[] specialValues) {
        PTextField txt = TextFieldFactory.createRightAlignedTextField();
        DiscontinuousNumberRangeValidator rangeValidator = new DiscontinuousNumberRangeValidator(minValue, maxValue, step);
        if (specialValues != null) {
            TextFieldFactory.initIntegerSpecialValuesValidation(txt, minValue, maxValue, rangeValidator, specialValues);
        } else {
            IntegerDocument doc = new IntegerDocument(minValue, maxValue);
            txt.setDocument(doc);
            doc.addPropertyChangeListener(rangeValidator);
            txt.addValidationListener(rangeValidator);
        }
        txt.setColumns(TextFieldValidationUtils.getColumns(minValue, maxValue, specialValues));
        return txt;
    }

    public static PTextField createLongTextField(long minValue, long maxValue) {
        return TextFieldFactory.createLongTextField(minValue, maxValue, null);
    }

    public static PTextField createLongTextField(long minValue, long maxValue, long[] specialValues) {
        return TextFieldFactory.createLongTextField(minValue, maxValue, specialValues, true);
    }

    public static PTextField createLongTextField(long minValue, long maxValue, long[] specialValues, boolean acceptFullwidthCharacters) {
        PTextField txt = TextFieldFactory.createRightAlignedTextField();
        NumberRangeValidator rangeValidator = new NumberRangeValidator(minValue, maxValue);
        if (specialValues != null) {
            TextFieldFactory.initLongSpecialValuesValidation(txt, minValue, maxValue, rangeValidator, specialValues);
        } else {
            txt.addValidationListener(rangeValidator);
            LongDocument doc = new LongDocument(minValue, maxValue, acceptFullwidthCharacters);
            doc.addPropertyChangeListener(rangeValidator);
            txt.setDocument(doc);
        }
        txt.enableInputMethods(false);
        txt.setColumns(TextFieldValidationUtils.getColumns(specialValues, minValue, maxValue));
        return txt;
    }

    public static PTextField createDiscontinuousLongRangeTextField(long minValue, long maxValue, long step, long[] specialValues) {
        return TextFieldFactory.createDiscontinuousLongRangeTextField(minValue, maxValue, step, specialValues, true);
    }

    public static PTextField createDiscontinuousLongRangeTextField(long minValue, long maxValue, long step, long[] specialValues, boolean acceptFullwidthCharacters) {
        PTextField txt = new PTextField();
        DiscontinuousNumberRangeValidator rangeValidator = new DiscontinuousNumberRangeValidator(minValue, maxValue, step);
        if (specialValues != null) {
            TextFieldFactory.initLongSpecialValuesValidation(txt, minValue, maxValue, rangeValidator, specialValues);
        } else {
            LongDocument doc = new LongDocument(minValue, maxValue, acceptFullwidthCharacters);
            txt.setDocument(doc);
            doc.addPropertyChangeListener(rangeValidator);
            txt.addValidationListener(rangeValidator);
        }
        txt.setColumns(TextFieldValidationUtils.getColumns(specialValues, minValue, maxValue));
        return txt;
    }

    public static PTextField createAlphaNumericTextField(int maxChars) {
        PTextField txt = new PTextField();
        txt.setDocument(new AlphaNumericDocument(maxChars));
        txt.setColumns(maxChars);
        return txt;
    }

    public static PTextField createAlphaNumericTextField(int maxChars, boolean allowXMLEntities) {
        PTextField txt = new PTextField();
        txt.setDocument(new AlphaNumericDocument(maxChars, allowXMLEntities));
        txt.setColumns(maxChars);
        return txt;
    }

    public static MultiLanguageTextField createUTF8EncodingTextField(int maxChars, boolean allowXMLEntities) {
        MultiLanguageTextField txt = new MultiLanguageTextField();
        txt.setDocument(new MultiLanguageTextFieldDocument(maxChars, allowXMLEntities, txt));
        txt.setColumns(maxChars);
        return txt;
    }

    public static PTextField createASN1PrintableStringTextField(int maxChars) {
        PTextField txt = new PTextField();
        txt.setDocument(new AlphaNumericDocument(maxChars){

            @Override
            public boolean isAllowedChar(char ch) {
                return ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == ' ' || ch == '\'' || ch == '(' || ch == ')' || ch == '+' || ch == ',' || ch == '-' || ch == '.' || ch == '/' || ch == ':' || ch == '=' || ch == '?';
            }
        });
        txt.setColumns(maxChars);
        return txt;
    }

    public static PTextField createFixedLengthNumericTextField(int maxChars) {
        AlphaNumericDocument doc = new AlphaNumericDocument(maxChars){

            @Override
            public boolean isAllowedChar(char ch) {
                return Character.isDigit(ch);
            }
        };
        PTextField txt = new PTextField(maxChars);
        txt.setDocument(doc);
        txt.setColumns(maxChars);
        return txt;
    }

    public static PTextField createFixedLengthTextField(int maxChars) {
        PTextField txt = new PTextField();
        txt.setDocument(new PFixedLengthDocument(maxChars));
        txt.setColumns(maxChars);
        return txt;
    }

    public static PTextField createFixedLengthAlphaNumericTextField(int maxChars, boolean allowXmlEntries) {
        PTextField txt = new PTextField();
        txt.setDocument(new FixedLengthAlphaNumericDocument(maxChars, allowXmlEntries));
        txt.setColumns(maxChars);
        return txt;
    }

    public static PTextField createFixedLengthAlphaNumericTextField(int maxChars) {
        PTextField txt = new PTextField();
        txt.setDocument(new FixedLengthAlphaNumericDocument(maxChars));
        txt.setColumns(maxChars);
        return txt;
    }

    public static PTextField createValidDecimalListTextField(List validValues) {
        PTextField txt = TextFieldFactory.createRightAlignedTextField();
        txt.addValidationListener(new DecimalListValidator(validValues));
        txt.setColumns(TextFieldValidationUtils.getColumns(validValues));
        return txt;
    }

    private static void initDoubleSpecialValuesValidation(PTextField txt, int maxDecimDigits, double minValue, double maxValue, PValidationListener rangeValidator, double[] specialValues) {
        double totalMinValue = TextFieldValidationUtils.min(minValue, maxValue, specialValues);
        double totalMaxValue = TextFieldValidationUtils.max(minValue, maxValue, specialValues);
        UnionValidator listener = new UnionValidator();
        listener.addValidationListener(new DecimalListValidator(specialValues));
        listener.addValidationListener(rangeValidator);
        txt.addValidationListener(listener);
        DecimalDocument doc = new DecimalDocument(maxDecimDigits, totalMinValue, totalMaxValue);
        txt.setDocument(doc);
    }

    private static void initIntegerSpecialValuesValidation(PTextField txt, int minValue, int maxValue, PValidationListener rangeValidator, int[] specialValues) {
        int totalMinValue = TextFieldValidationUtils.min(minValue, maxValue, specialValues);
        int totalMaxValue = TextFieldValidationUtils.max(minValue, maxValue, specialValues);
        UnionValidator listener = new UnionValidator();
        listener.addValidationListener(new IntegerListValidator(specialValues));
        listener.addValidationListener(rangeValidator);
        txt.addValidationListener(listener);
        IntegerDocument doc = new IntegerDocument(totalMinValue, totalMaxValue);
        txt.setDocument(doc);
    }

    private static void initLongSpecialValuesValidation(PTextField txt, long minValue, long maxValue, PValidationListener rangeValidator, long[] specialValues) {
        long totalMinValue = TextFieldValidationUtils.min(minValue, maxValue, specialValues);
        long totalMaxValue = TextFieldValidationUtils.max(minValue, maxValue, specialValues);
        UnionValidator listener = new UnionValidator();
        listener.addValidationListener(new LongListValidator(specialValues));
        listener.addValidationListener(rangeValidator);
        txt.addValidationListener(listener);
        LongDocument doc = new LongDocument(totalMinValue, totalMaxValue);
        txt.setDocument(doc);
    }

    private static PTextField createRightAlignedTextField() {
        PTextField txt = new PTextField();
        txt.setValidateOnFocusLost(true);
        return txt;
    }
}

