/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import javax.swing.text.NumberFormatter;

public class TextFieldValidationUtils {
    private static final NumberFormatter NUMBER_FORMATTER = new NumberFormatter(NumberFormat.getNumberInstance());

    public static int max(int min, int max, int[] values) {
        if (values == null) {
            return Math.max(min, max);
        }
        int[] allValues = new int[values.length + 2];
        System.arraycopy(values, 0, allValues, 0, values.length);
        allValues[values.length] = min;
        allValues[values.length + 1] = max;
        Arrays.sort(allValues);
        return allValues[allValues.length - 1];
    }

    public static int min(int min, int max, int[] values) {
        if (values == null) {
            return Math.min(min, max);
        }
        int[] allValues = new int[values.length + 2];
        System.arraycopy(values, 0, allValues, 0, values.length);
        allValues[values.length] = min;
        allValues[values.length + 1] = max;
        Arrays.sort(allValues);
        return allValues[0];
    }

    public static long max(long min, long max, long[] values) {
        if (values == null) {
            return Math.max(min, max);
        }
        long[] allValues = new long[values.length + 2];
        System.arraycopy(values, 0, allValues, 0, values.length);
        allValues[values.length] = min;
        allValues[values.length + 1] = max;
        Arrays.sort(allValues);
        return allValues[allValues.length - 1];
    }

    public static long min(long min, long max, long[] values) {
        if (values == null) {
            return Math.min(min, max);
        }
        long[] allValues = new long[values.length + 2];
        System.arraycopy(values, 0, allValues, 0, values.length);
        allValues[values.length] = min;
        allValues[values.length + 1] = max;
        Arrays.sort(allValues);
        return allValues[0];
    }

    public static double max(double min, double max, double[] values) {
        if (values == null) {
            return Math.max(min, max);
        }
        double[] allValues = new double[values.length + 2];
        System.arraycopy(values, 0, allValues, 0, values.length);
        allValues[values.length] = min;
        allValues[values.length + 1] = max;
        Arrays.sort(allValues);
        return allValues[allValues.length - 1];
    }

    public static double min(double min, double max, double[] values) {
        if (values == null) {
            return Math.min(min, max);
        }
        double[] allValues = new double[values.length + 2];
        System.arraycopy(values, 0, allValues, 0, values.length);
        allValues[values.length] = min;
        allValues[values.length + 1] = max;
        Arrays.sort(allValues);
        return allValues[0];
    }

    public static int getColumns(List validValues) {
        Double[] doubleArray = validValues.toArray(new Double[validValues.size()]);
        int maxLength = 0;
        int idx = 0;
        while (idx < doubleArray.length) {
            String nextString = "";
            try {
                nextString = NUMBER_FORMATTER.valueToString(doubleArray[idx]);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            maxLength = Math.max(maxLength, nextString.length());
            ++idx;
        }
        return maxLength;
    }

    public static int getColumns(int min, int max, int[] specialValues) {
        int totalMin = TextFieldValidationUtils.min(min, max, specialValues);
        int totalMax = TextFieldValidationUtils.max(min, max, specialValues);
        String minString = String.valueOf(totalMin);
        String maxString = String.valueOf(totalMax);
        return Math.max(maxString.length(), minString.length());
    }

    public static int getColumns(long[] specialValues, long min, long max) {
        long totalMin = TextFieldValidationUtils.min(min, max, specialValues);
        long totalMax = TextFieldValidationUtils.max(min, max, specialValues);
        String minString = String.valueOf(totalMin);
        String maxString = String.valueOf(totalMax);
        return Math.max(maxString.length(), minString.length());
    }

    public static int getColumns(int maxDecimalDigits, double min, double max, double[] specialValues) {
        int totalMinInt = (int)TextFieldValidationUtils.min(min, max, specialValues);
        int totalMaxInt = (int)TextFieldValidationUtils.max(min, max, specialValues);
        String minString = String.valueOf(totalMinInt);
        String maxString = String.valueOf(totalMaxInt);
        int maxInt = Math.max(maxString.length(), minString.length());
        return maxInt + 1 + maxDecimalDigits;
    }

    public static long[] convertArrayDoubleToLong(double[] arrayDouble) {
        if (arrayDouble == null) {
            return null;
        }
        long[] arrayInt = new long[arrayDouble.length];
        int index = 0;
        while (index < arrayDouble.length) {
            arrayInt[index] = (long)arrayDouble[index];
            ++index;
        }
        return arrayInt;
    }
}

