/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class TimeZoneFormatter {
    private TimeZoneFormatter() {
    }

    public static String formatGMTText(Calendar time) {
        if (time == null) {
            return "";
        }
        TimeZone timeZone = time.getTimeZone();
        long offset = timeZone.getRawOffset();
        Calendar gmtTime = TimeZoneFormatter.generateGMTTime(offset);
        boolean isDaylightTime = timeZone.inDaylightTime(time.getTime());
        return TimeZoneFormatter.generateGMTText(offset, gmtTime, isDaylightTime);
    }

    public static String formatGMTText(TimeZone timeZone, Date date) {
        if (timeZone == null || date == null) {
            return "";
        }
        long offset = timeZone.getRawOffset();
        Calendar gmtTime = TimeZoneFormatter.generateGMTTime(offset);
        boolean isDaylightTime = timeZone.inDaylightTime(date);
        return TimeZoneFormatter.generateGMTText(offset, gmtTime, isDaylightTime);
    }

    private static String generateGMTText(long offset, Calendar gmtTime, boolean isDaylightTime) {
        StringBuilder gmtText = new StringBuilder("GMT ");
        gmtText.append(offset < 0L ? "-" : "+");
        gmtText.append(TimeZoneFormatter.formatTimeField(gmtTime, 11));
        gmtText.append(TimeZoneFormatter.formatTimeField(gmtTime, 12));
        gmtText.append(isDaylightTime ? " DST" : "");
        return gmtText.toString();
    }

    private static Calendar generateGMTTime(long offset) {
        Calendar gmtTime = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        gmtTime.setTimeInMillis(Math.abs(offset));
        return gmtTime;
    }

    private static String formatTimeField(Calendar calendar, int field) {
        String fieldStr = String.valueOf(calendar.get(field));
        return fieldStr.length() == 1 ? "0" + fieldStr : fieldStr;
    }
}

