/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimestampFormatter {
    private static final String SHORT_PATTERN = "dd.MM.yyyy";
    private static final String MEDIUM_PATTERN = "dd.MM.yyyy HH:mm";
    private static final String LONG_PATTERN = "dd.MM.yyyy HH:mm:ss";
    private static final DateFormat DATE_FORMATTER_FOR_SHORT = new SimpleDateFormat("dd.MM.yyyy");
    private static final DateFormat DATE_FORMATTER_FOR_MEDIUM = new SimpleDateFormat("dd.MM.yyyy HH:mm");
    private static final DateFormat DATE_FORMATTER_FOR_LONG = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    private TimestampFormatter() {
    }

    public static String applyShortFormat(Date date) {
        if (date == null) {
            return "";
        }
        return DATE_FORMATTER_FOR_SHORT.format(date);
    }

    public static String applyShortFormat(Calendar time) {
        if (time == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(SHORT_PATTERN);
        dateFormat.setTimeZone(time.getTimeZone());
        return dateFormat.format(time.getTime());
    }

    public static String applyMediumFormat(Date date) {
        if (date == null) {
            return "";
        }
        return DATE_FORMATTER_FOR_MEDIUM.format(date);
    }

    public static String applyMediumFormat(Calendar time) {
        if (time == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(MEDIUM_PATTERN);
        dateFormat.setTimeZone(time.getTimeZone());
        return dateFormat.format(time.getTime());
    }

    public static String applyLongFormat(Date date) {
        if (date == null) {
            return "";
        }
        return DATE_FORMATTER_FOR_LONG.format(date);
    }

    public static String applyLongFormat(Calendar time) {
        if (time == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(LONG_PATTERN);
        dateFormat.setTimeZone(time.getTimeZone());
        return dateFormat.format(time.getTime());
    }

    public static String applyShortFormat(Date date, TimeZone targetTimeZone) {
        return TimestampFormatter.convertToTargetTimeZoneFormat(date, targetTimeZone, SHORT_PATTERN);
    }

    public static String applyShortFormat(Calendar time, TimeZone targetTimeZone) {
        if (time == null) {
            return "";
        }
        return TimestampFormatter.applyShortFormat(time.getTime(), targetTimeZone);
    }

    public static String applyMediumFormat(Date date, TimeZone targetTimeZone) {
        return TimestampFormatter.convertToTargetTimeZoneFormat(date, targetTimeZone, MEDIUM_PATTERN);
    }

    public static String applyMediumFormat(Calendar time, TimeZone targetTimeZone) {
        if (time == null) {
            return "";
        }
        return TimestampFormatter.applyMediumFormat(time.getTime(), targetTimeZone);
    }

    public static String applyLongFormat(Date date, TimeZone targetTimeZone) {
        return TimestampFormatter.convertToTargetTimeZoneFormat(date, targetTimeZone, LONG_PATTERN);
    }

    public static String applyLongFormat(Calendar time, TimeZone targetTimeZone) {
        if (time == null) {
            return "";
        }
        return TimestampFormatter.applyLongFormat(time.getTime(), targetTimeZone);
    }

    private static String convertToTargetTimeZoneFormat(Date date, TimeZone targetTimeZone, String targetPattern) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(targetPattern);
        dateFormat.setTimeZone(targetTimeZone);
        return dateFormat.format(date.getTime());
    }

    public static DateFormat getShortFormatter() {
        return new SimpleDateFormat(SHORT_PATTERN);
    }

    public static DateFormat getMediumFormatter() {
        return new SimpleDateFormat(MEDIUM_PATTERN);
    }

    public static DateFormat getLongFormatter() {
        return new SimpleDateFormat(LONG_PATTERN);
    }
}

