/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text;

import com.nokia.widgets.text.PValidationEvent;
import com.nokia.widgets.text.PValidationException;
import com.nokia.widgets.text.PValidationListener;
import java.util.ArrayList;
import java.util.List;

public class UnionValidator
implements PValidationListener {
    private final List mySubValidationListeners = new ArrayList();

    public void addValidationListener(PValidationListener listener) {
        if (listener != null && !this.mySubValidationListeners.contains(listener)) {
            this.mySubValidationListeners.add(listener);
        }
    }

    public void removeValidationListener(PValidationListener listener) {
        this.mySubValidationListeners.remove(listener);
    }

    @Override
    public void validate(PValidationEvent event) throws PValidationException {
        if (this.mySubValidationListeners.isEmpty()) {
            return;
        }
        boolean someListenerAccepts = false;
        for (PValidationListener listener : this.mySubValidationListeners) {
            try {
                listener.validate(event);
                someListenerAccepts = true;
            }
            catch (PValidationException pValidationException) {
                // empty catch block
            }
        }
        if (!someListenerAccepts) {
            throw new PValidationException();
        }
    }
}

