/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text.search;

import com.nokia.widgets.PPanel;
import com.nokia.widgets.buttons.PButton;
import com.nokia.widgets.icons.TriangleIcon;
import com.nokia.widgets.layout.PHorizontalLayout;
import com.nokia.widgets.text.PTextField;
import com.nokia.widgets.util.ImageUtils;
import com.nokia.widgets.util.WidgetResources;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.text.Position;

public abstract class SearchBar
extends PPanel {
    private static final long serialVersionUID = -903692886331024597L;
    protected PButton myPrevMatchButton;
    protected PButton myNextMatchButton;
    protected JLabel myNumberOfMatches;
    protected PTextField mySearchField = new PTextField();
    protected int myMatchCount = 0;
    protected int myMaxSearchCount = 200;
    protected Position.Bias myPreviousSearchDirection;
    private boolean myUpdateSearchResultsOnModelUpdate = false;

    protected void addListeners() {
        this.bindKeyboardAction();
        this.myNextMatchButton.addActionListener(new IterationMatchAction(Position.Bias.Forward));
        this.myPrevMatchButton.addActionListener(new IterationMatchAction(Position.Bias.Backward));
    }

    private void bindKeyboardAction() {
        KeyStroke shiftEnter = KeyStroke.getKeyStroke(10, 1);
        this.getPTextField().getInputMap(0).put(shiftEnter, "previousMatch");
        this.getPTextField().getActionMap().put("previousMatch", new IterationMatchAction(Position.Bias.Backward));
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        this.getPTextField().getInputMap(0).put(enter, "nextMatch");
        this.getPTextField().getActionMap().put("nextMatch", new IterationMatchAction(Position.Bias.Forward));
        KeyStroke f3 = KeyStroke.getKeyStroke(114, 0);
        KeyStroke shiftF3 = KeyStroke.getKeyStroke(114, 1);
        this.myNextMatchButton.getInputMap(2).put(f3, "nextMatch");
        this.myNextMatchButton.getActionMap().put("nextMatch", new IterationMatchAction(Position.Bias.Forward));
        this.myPrevMatchButton.getInputMap(2).put(shiftF3, "previousMatch");
        this.myPrevMatchButton.getActionMap().put("previousMatch", new IterationMatchAction(Position.Bias.Backward));
    }

    protected void buildUI() {
        this.mySearchField = this.getPTextField();
        this.mySearchField.setSearchField(true);
        this.mySearchField.setColumns(10);
        this.myNumberOfMatches = new JLabel();
        this.myNumberOfMatches.setName("SearchBar.matchCountLabel");
        this.myNextMatchButton = new PButton(new ImageIcon(ImageUtils.createFlippedImage(null, new TriangleIcon())));
        this.myNextMatchButton.putClientProperty("OrangeTouch.roundedOutline", true);
        this.myPrevMatchButton = new PButton(new ImageIcon(ImageUtils.createImage(null, new TriangleIcon())));
        this.myPrevMatchButton.putClientProperty("OrangeTouch.roundedOutline", true);
        this.setSearchButtonsEnabled(false);
        this.myPrevMatchButton.setName("SearchBar.previousMatchButton");
        this.myNextMatchButton.setName("SearchBar.nextMatchButton");
        this.myNextMatchButton.setToolTipText(WidgetResources.getString("Search_Next_Tooltip"));
        this.myPrevMatchButton.setToolTipText(WidgetResources.getString("Search_Previous_Tooltip"));
        this.setLayout(new PHorizontalLayout(2, 0, 0, 0));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setComponentsAccessibilityInfo();
        this.add(this.mySearchField);
        this.add(Box.createHorizontalStrut(10));
        this.add(this.myNextMatchButton);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.myPrevMatchButton);
        this.add(Box.createHorizontalStrut(10));
        this.add(this.myNumberOfMatches);
        this.addListeners();
    }

    protected void setComponentsAccessibilityInfo() {
        this.mySearchField.getAccessibleContext().setAccessibleName(WidgetResources.getString("Search.Field"));
        this.mySearchField.getAccessibleContext().setAccessibleDescription(WidgetResources.getString("Search.Field.Description"));
    }

    public void setMatchCountVisible(boolean visible) {
        this.myNumberOfMatches.setVisible(visible);
    }

    public void clearSearchTextField() {
        this.mySearchField.setText("");
    }

    protected PTextField getPTextField() {
        return this.mySearchField;
    }

    public int getMaxSearchCount() {
        return this.myMaxSearchCount;
    }

    protected abstract void nextMatchAction(ActionEvent var1);

    protected abstract void previousMatchAction(ActionEvent var1);

    protected boolean isSearchDirectionChanged(Position.Bias bias) {
        return this.myPreviousSearchDirection != null && !this.myPreviousSearchDirection.equals(bias);
    }

    public void setMaxSearchCount(int maxSearchCount) {
        this.myMaxSearchCount = maxSearchCount;
    }

    protected void setSearchButtonsEnabled(boolean enabled) {
        this.myNextMatchButton.setEnabled(enabled);
        this.myPrevMatchButton.setEnabled(enabled);
    }

    protected void updateMatchesCount() {
        if (this.mySearchField.getText() == null || this.mySearchField.getText().isEmpty()) {
            this.myNumberOfMatches.setText("");
            return;
        }
        String messageKey = "MatchLabel_Text";
        if (this.myMatchCount == 0) {
            messageKey = "MatchLabelNoMatches_Text";
        } else if (this.myMatchCount == 1) {
            messageKey = "MatchLabelOneMatch_Text";
        } else if (this.myMaxSearchCount != -1 && this.myMatchCount > this.myMaxSearchCount) {
            messageKey = "MatchLabelMaxMatchesReached_Text";
            this.myMatchCount = this.myMaxSearchCount;
        }
        String text = MessageFormat.format(WidgetResources.getString(messageKey), String.valueOf(this.myMatchCount));
        this.myNumberOfMatches.setText(text);
    }

    public void setPreviousSearchDirection(Position.Bias bias) {
        this.myPreviousSearchDirection = bias;
    }

    public boolean isUpdateSearchResultsOnModelUpdate() {
        return this.myUpdateSearchResultsOnModelUpdate;
    }

    public void setUpdateSearchResultsOnModelUpdate(boolean update) {
        this.myUpdateSearchResultsOnModelUpdate = update;
    }

    private final class IterationMatchAction
    extends AbstractAction {
        private static final long serialVersionUID = -6418527707824896942L;
        private Position.Bias myDirection;

        public IterationMatchAction(Position.Bias direction) {
            this.myDirection = direction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.myDirection == Position.Bias.Forward) {
                SearchBar.this.nextMatchAction(e);
            } else if (this.myDirection == Position.Bias.Backward) {
                SearchBar.this.previousMatchAction(e);
            }
        }
    }
}

