/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text.search;

import com.nokia.widgets.text.PTextField;
import com.nokia.widgets.text.search.SearchBar;
import com.nokia.widgets.util.NSNColors;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLDocument;

public class TextPaneSearchBar
extends SearchBar
implements DocumentListener {
    private static final long serialVersionUID = -6226248209564142864L;
    private StyledDocument myStyledDocument;
    private final boolean myIsOrdinaryTextBold;
    private final Color myOrdinaryTextForegroundColor;
    private final JTextPane myTextPane;
    private final Highlighter myHighlighter = new DefaultHighlighter();
    private ListIterator<Object[]> mySearchIterator = null;
    private List<Object[]> mySearchMatches = new ArrayList<Object[]>();
    private MutableAttributeSet myBoldStyle;
    private MutableAttributeSet myFocusedMatchForegroundStyle;
    private MutableAttributeSet myOrdinaryStyle;
    private Object[] myCurrentFocusTag = null;
    private final Highlighter.HighlightPainter myFocusPainter = new DefaultHighlighter.DefaultHighlightPainter(NSNColors.getPurple());
    private final Highlighter.HighlightPainter myNormalPainter = new DefaultHighlighter.DefaultHighlightPainter(NSNColors.getGreen());

    public TextPaneSearchBar(JTextPane textPane) {
        this(textPane, Color.BLACK, false);
    }

    public TextPaneSearchBar(JTextPane textPane, Color foregroundColor, boolean bold) {
        this.myTextPane = textPane;
        this.myOrdinaryTextForegroundColor = foregroundColor;
        this.myIsOrdinaryTextBold = bold;
        this.mySearchField = new TextPaneSearchField();
        this.buildUI();
        this.addStyling();
        this.mySearchField.getDocument().addDocumentListener(this);
    }

    private void addSearchMatch(int start, int end, Object tag) {
        Object[] index = new Object[]{start, end, tag};
        this.mySearchMatches.add(index);
        this.mySearchIterator = this.mySearchMatches.listIterator();
    }

    private void addStyling() {
        this.myTextPane.setHighlighter(this.myHighlighter);
        this.myStyledDocument = this.myTextPane.getStyledDocument();
        this.myFocusedMatchForegroundStyle = this.createSimpleAttribute(true, Color.WHITE);
        this.myBoldStyle = this.createSimpleAttribute(true, Color.BLACK);
        this.myOrdinaryStyle = this.createSimpleAttribute(this.myIsOrdinaryTextBold, this.myOrdinaryTextForegroundColor);
    }

    private MutableAttributeSet createSimpleAttribute(boolean isBold, Color color) {
        SimpleAttributeSet attribute = new SimpleAttributeSet();
        StyleConstants.setBold(attribute, isBold);
        StyleConstants.setForeground(attribute, color);
        return attribute;
    }

    private void callUserAttention(Object[] searchMatch) {
        Integer start = (Integer)searchMatch[0];
        Integer length = (Integer)searchMatch[1];
        Object tag = searchMatch[2];
        if (this.myCurrentFocusTag != null) {
            int offset = (Integer)this.myCurrentFocusTag[0];
            int origLength = (Integer)this.myCurrentFocusTag[1];
            this.changeBacktoDefaultForeground(offset, origLength);
            this.myHighlighter.removeHighlight(this.myCurrentFocusTag[2]);
            try {
                if (this.mySearchMatches.size() > 1) {
                    Object newOrdinaryTag;
                    this.myCurrentFocusTag[2] = newOrdinaryTag = this.myHighlighter.addHighlight(offset, offset + origLength, this.myNormalPainter);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.myHighlighter.removeHighlight(tag);
        try {
            Object focusTag;
            this.myCurrentFocusTag = searchMatch;
            this.myCurrentFocusTag[2] = focusTag = this.myHighlighter.addHighlight(start, start + length, this.myFocusPainter);
            this.myTextPane.setCaretPosition(start);
            this.myStyledDocument.setCharacterAttributes(start, length, this.myFocusedMatchForegroundStyle, false);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void changeBacktoDefaultForeground(int offset, int length) {
        this.myStyledDocument.setCharacterAttributes(offset, length, this.myBoldStyle, false);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private void clearMatches() {
        this.mySearchMatches.clear();
        this.mySearchIterator = this.mySearchMatches.listIterator();
        this.myPreviousSearchDirection = null;
    }

    private void correctMatch(Position.Bias direction) {
        if (this.myPreviousSearchDirection == null) {
            this.myPreviousSearchDirection = direction;
        } else if (!this.myPreviousSearchDirection.equals(direction)) {
            if (this.myPreviousSearchDirection == Position.Bias.Backward) {
                this.getNextMatchNoCorrection();
            } else {
                this.getPrevMatchNoCorrection();
            }
            this.myPreviousSearchDirection = direction;
        }
    }

    public Integer getMatchCount() {
        String searchKeyword = this.mySearchField.getText();
        if (searchKeyword.isEmpty()) {
            return null;
        }
        return this.myMatchCount;
    }

    private Object[] getNextMatch() {
        if (this.mySearchMatches.isEmpty()) {
            return null;
        }
        this.correctMatch(Position.Bias.Forward);
        return this.getNextMatchNoCorrection();
    }

    private Object[] getNextMatchNoCorrection() {
        if (this.mySearchIterator.hasNext()) {
            return this.mySearchIterator.next();
        }
        this.mySearchIterator = this.mySearchMatches.listIterator();
        if (this.mySearchIterator.hasNext()) {
            return this.mySearchIterator.next();
        }
        return null;
    }

    private Object[] getPrevMatch() {
        if (this.mySearchMatches.isEmpty()) {
            return null;
        }
        this.correctMatch(Position.Bias.Backward);
        return this.getPrevMatchNoCorrection();
    }

    private Object[] getPrevMatchNoCorrection() {
        if (this.mySearchIterator.hasPrevious()) {
            return this.mySearchIterator.previous();
        }
        this.mySearchIterator = this.mySearchMatches.listIterator(this.mySearchMatches.size());
        if (this.mySearchIterator.hasPrevious()) {
            return this.mySearchIterator.previous();
        }
        return null;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.search();
    }

    @Override
    protected void nextMatchAction(ActionEvent e) {
        Object[] index = this.getNextMatch();
        if (index != null) {
            this.callUserAttention(index);
        }
    }

    @Override
    protected void previousMatchAction(ActionEvent e) {
        Object[] index = this.getPrevMatch();
        if (index != null) {
            this.callUserAttention(index);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.search();
    }

    public void resetSearch() {
        if (this.myCurrentFocusTag != null) {
            this.changeBacktoDefaultForeground((Integer)this.myCurrentFocusTag[0], (Integer)this.myCurrentFocusTag[1]);
            this.myCurrentFocusTag = null;
        }
        Document document = this.myTextPane.getDocument();
        if (this.myMatchCount > 0) {
            this.myStyledDocument.setCharacterAttributes(0, document.getLength(), this.myOrdinaryStyle, false);
        }
        this.myMatchCount = 0;
        this.clearMatches();
        this.myHighlighter.removeAllHighlights();
        this.setSearchButtonsEnabled(false);
        this.updateMatchesCount();
        this.clearMatches();
    }

    private void search() {
        this.resetSearch();
        String searchKeyword = this.mySearchField.getText();
        int strLength = searchKeyword.length();
        this.updateMatchesCount();
        if (strLength == 0) {
            return;
        }
        Document document = this.myTextPane.getDocument();
        Pattern pattern = Pattern.compile(Pattern.quote(searchKeyword), 2);
        try {
            Matcher matcher = pattern.matcher(document.getText(0, document.getLength()));
            while (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                Object tag = this.myHighlighter.addHighlight(start, end, this.myNormalPainter);
                this.myStyledDocument.setCharacterAttributes(start, strLength, this.myBoldStyle, false);
                this.addSearchMatch(start, strLength, tag);
                ++this.myMatchCount;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (this.myMatchCount > 0) {
            this.setSearchButtonsEnabled(true);
            this.nextMatchAction(new ActionEvent(this, 0, ""));
        }
        this.updateMatchesCount();
        this.encodeToHTMLSourceCode(document);
    }

    private void encodeToHTMLSourceCode(Document document) {
        if (document != null && document instanceof HTMLDocument) {
            try {
                String documentTextString = document.getText(0, document.getLength());
                documentTextString = documentTextString.replaceAll("&", "&amp;");
                documentTextString = documentTextString.replaceAll("'", "&#39;");
                documentTextString = documentTextString.replaceAll("\"", "&quot;");
                documentTextString = documentTextString.replaceAll("<", "&lt;");
                documentTextString = documentTextString.replaceAll(">", "&gt;");
                documentTextString = documentTextString.replaceAll("\n", "<br>");
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void search(String query) {
        this.mySearchField.setText(query);
    }

    public void setSearchText(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextPaneSearchBar.this.mySearchField.setText(text);
            }
        });
    }

    private class TextPaneSearchField
    extends PTextField {
        private TextPaneSearchField() {
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            if (this.isOnClearIcon(event.getPoint())) {
                return WidgetResources.getString("ClearSearchButton_TooltipText");
            }
            return super.getToolTipText(event);
        }
    }
}

