/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text.status;

import com.nokia.widgets.text.status.ModifiedStatusHandler;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class ComboBoxModifiedStatusHandler
extends ModifiedStatusHandler
implements ItemListener,
DocumentListener {
    private JComboBox myComboBox;

    public ComboBoxModifiedStatusHandler(JComboBox comboBox) {
        super(comboBox);
        this.myComboBox = comboBox;
        this.installListeners();
    }

    @Override
    public Object getValue() {
        JTextComponent editor = this.getEditorComponentAsTextField();
        if (this.myComboBox.isEditable() && editor != null) {
            return editor.getText();
        }
        return this.myComboBox.getSelectedItem();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.myComboBox.addItemListener(this);
        JTextComponent editor = this.getEditorComponentAsTextField();
        if (editor != null) {
            editor.getDocument().addDocumentListener(this);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.myComboBox.removeItemListener(this);
        JTextComponent editor = this.getEditorComponentAsTextField();
        if (editor != null) {
            editor.getDocument().removeDocumentListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if ("editor".equals(evt.getPropertyName())) {
            JTextComponent newTextEditor;
            ComboBoxEditor oldEditor = (ComboBoxEditor)evt.getOldValue();
            ComboBoxEditor newEditor = (ComboBoxEditor)evt.getNewValue();
            JTextComponent oldTextEditor = this.getEditorComponentAsTextField(oldEditor);
            if (oldTextEditor != null) {
                oldTextEditor.getDocument().removeDocumentListener(this);
            }
            if ((newTextEditor = this.getEditorComponentAsTextField(newEditor)) != null) {
                newTextEditor.getDocument().addDocumentListener(this);
            }
        }
        if ("editable".equals(evt.getPropertyName()) || "model".equals(evt.getPropertyName())) {
            this.updateModifiedStatus();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.updateModifiedStatus();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateModifiedStatus();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    private JTextComponent getEditorComponentAsTextField(ComboBoxEditor editor) {
        if (editor != null && editor.getEditorComponent() instanceof JTextComponent) {
            return (JTextComponent)editor.getEditorComponent();
        }
        return null;
    }

    private JTextComponent getEditorComponentAsTextField() {
        return this.getEditorComponentAsTextField(this.myComboBox.getEditor());
    }
}

