/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text.status;

import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.text.status.ComboBoxModifiedStatusHandler;
import com.nokia.widgets.text.status.SpinnerModifiedStatusHandler;
import com.nokia.widgets.text.status.TextFieldModifiedStatusHandler;
import com.nokia.widgets.text.status.ToggleButtonModifiedStatusHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.Comparator;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.text.JTextComponent;

public abstract class ModifiedStatusHandler
implements PropertyChangeListener {
    private static Comparator<Object> DEFAULT_COMPARATOR = new DefaultComparator();
    protected JComponent myComponent;

    public static ModifiedStatusHandler create(JTextComponent spinner) {
        return new TextFieldModifiedStatusHandler(spinner);
    }

    public static ModifiedStatusHandler create(JSpinner spinner) {
        return new SpinnerModifiedStatusHandler(spinner);
    }

    public static ModifiedStatusHandler create(JComboBox comp) {
        return new ComboBoxModifiedStatusHandler(comp);
    }

    public static ModifiedStatusHandler create(AbstractButton comp) {
        return new ToggleButtonModifiedStatusHandler(comp);
    }

    public ModifiedStatusHandler(JComponent comp) {
        this.myComponent = comp;
    }

    protected void installListeners() {
        this.myComponent.addPropertyChangeListener(this);
    }

    protected void uninstallListeners() {
        this.myComponent.removePropertyChangeListener(this);
    }

    public void uninstallFrom(JComponent comp) {
        this.uninstallListeners();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("BlueTouch.unmodifiedValue".equals(evt.getPropertyName())) {
            this.updateModifiedStatus();
        }
    }

    protected void updateModifiedStatus() {
        Object unmodifiedValue = this.myComponent.getClientProperty("BlueTouch.unmodifiedValue");
        if (unmodifiedValue == null) {
            this.myComponent.putClientProperty("BlueTouch.isModified", null);
            this.myComponent.repaint();
            return;
        }
        Object value = this.getValue();
        this.myComponent.putClientProperty("BlueTouch.isModified", this.isValueModified(this.myComponent, value));
        this.myComponent.repaint();
    }

    public abstract Object getValue();

    private boolean isValueModified(JComponent comp, Object value) {
        Object unmodifiedValue = comp.getClientProperty("BlueTouch.unmodifiedValue");
        if (unmodifiedValue == null) {
            return false;
        }
        Comparator<Object> valueComparator = (Comparator<Object>)comp.getClientProperty(ClientProperties.VALUE_COMPARATOR);
        if (valueComparator == null) {
            valueComparator = DEFAULT_COMPARATOR;
        }
        return valueComparator.compare(unmodifiedValue, value) != 0;
    }

    private static class DefaultComparator
    implements Comparator<Object> {
        private DefaultComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                String stringValue = o2.toString();
                return stringValue.length() == 0 ? 0 : -1;
            }
            if (o1 != null && o2 == null) {
                String stringValue = o1.toString();
                return stringValue.length() == 0 ? 0 : 1;
            }
            try {
                BigDecimal decimal1 = new BigDecimal(o1.toString());
                BigDecimal decimal2 = new BigDecimal(o2.toString());
                return decimal1.compareTo(decimal2);
            }
            catch (Exception e) {
                return o1.toString().compareTo(o2.toString());
            }
        }
    }
}

