/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.text.status;

import com.nokia.widgets.text.status.ModifiedStatusHandler;
import java.beans.PropertyChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class TextFieldModifiedStatusHandler
extends ModifiedStatusHandler
implements DocumentListener {
    private JTextComponent myTextComponent;

    public TextFieldModifiedStatusHandler(JTextComponent comp) {
        super(comp);
        this.myTextComponent = comp;
        this.installListeners();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (this.myTextComponent.getClientProperty("BlueTouch.unmodifiedValue") != null) {
            this.updateModifiedStatus();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if ("document".equals(evt.getPropertyName())) {
            Document oldDoc;
            Document newDoc = (Document)evt.getNewValue();
            if (newDoc != null) {
                newDoc.addDocumentListener(this);
            }
            if ((oldDoc = (Document)evt.getOldValue()) != null) {
                oldDoc.removeDocumentListener(this);
            }
            this.updateModifiedStatus();
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.myTextComponent.getDocument() != null) {
            this.myTextComponent.getDocument().removeDocumentListener(this);
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (this.myTextComponent.getDocument() != null) {
            this.myTextComponent.getDocument().addDocumentListener(this);
        }
    }

    @Override
    public Object getValue() {
        return this.myTextComponent.getText();
    }
}

