/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.toggle;

import com.nokia.widgets.toggle.ToggleUI;
import com.nokia.widgets.util.WidgetResources;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class Toggle
extends JToggleButton {
    private static final String UI_CLASS_ID = "ToggleUI";
    private boolean myAlternate = false;

    static {
        UIManager.put(UI_CLASS_ID, ToggleUI.class.getName());
    }

    public Toggle() {
        super(WidgetResources.getString("Toggle_Text"));
    }

    public Toggle(boolean isSelected) {
        this();
        this.setSelected(isSelected);
    }

    public Toggle(boolean isSelected, boolean isAlternate) {
        this();
        this.setAlternate(isAlternate);
        this.setSelected(isSelected);
    }

    @Override
    public void setSelected(boolean isSelected) {
        super.setSelected(isSelected);
        this.updateState(isSelected);
    }

    @Override
    public void doClick(int pressTime) {
        super.doClick(pressTime);
        this.updateState(this.isSelected());
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    @Override
    public void updateUI() {
        this.setUI((ToggleUI)UIManager.getUI(this));
    }

    public void setSizeVariant(String sizeVariant) {
        this.putClientProperty("JComponent.sizeVariant", sizeVariant);
    }

    public boolean isAlternate() {
        return this.myAlternate;
    }

    public void setAlternate(boolean value) {
        if (this.myAlternate != value) {
            this.myAlternate = value;
            this.repaint();
        }
    }

    private void updateState(boolean isSelected) {
        int state = isSelected ? 2 : 0;
        ToggleUI toggleUI = (ToggleUI)this.getUI();
        toggleUI.setState(state);
    }
}

