/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.toggle;

import com.nokia.laf.NetTheme;
import com.nokia.laf.borders.BaseBorder;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.toggle.Toggle;
import com.nokia.widgets.toggle.ToggleUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class ToggleBorder
extends BaseBorder {
    public ToggleBorder() {
        super(new Insets(2, 3, 4, 3));
    }

    @Override
    public void paintBorder(Component comp, Graphics graphics, int x, int y, int w, int h) {
        AbstractButton button = (AbstractButton)comp;
        ButtonModel model = button.getModel();
        Toggle toggle = (Toggle)comp;
        ToggleUI ui = (ToggleUI)toggle.getUI();
        boolean isPressed = model.isPressed() && model.isArmed();
        boolean isHover = model.isRollover();
        boolean isKnobStateLeft = ui.getState() == 2;
        boolean isKnobStateMovingRight = ui.getState() == 3;
        Shape shape = graphics.getClip();
        Color lineColor = toggle.isAlternate() ? (model.isEnabled() ? UIManager.getColor(isKnobStateLeft || isKnobStateMovingRight ? "Toggle.onOutline" : "Toggle.offOutline") : UIManager.getColor(isKnobStateLeft ? "Toggle.disabledOnOutline" : "Toggle.disabledOffOutline")) : UIManager.getColor(model.isEnabled() ? "Toggle.outline" : "Toggle.disabledOutline");
        int rounding = NetTheme.getComponentOutlineRounding(button);
        if (!ui.getAnimationTimer().isRunning()) {
            int xPosition = isKnobStateLeft ? 10 : 0;
            graphics.clipRect(xPosition, 0, comp.getWidth() - 10, comp.getHeight());
        }
        NetUtils.drawButtonOutline(graphics, (JComponent)button, lineColor);
        graphics.setClip(shape);
        lineColor = model.isEnabled() ? (isHover && !isPressed ? NetTheme.getHoverColor() : (button.isFocusOwner() && button.isFocusPainted() ? UIManager.getColor("Toggle.knobFocusColor") : UIManager.getColor("Toggle.knobOutline"))) : UIManager.getColor("Toggle.disabledKnobOutline");
        NetUtils.drawRoundedRect(graphics, lineColor, ui.getKnobXPosition() - 1, 1, comp.getWidth() / 2 - 1, comp.getHeight() - 5, rounding);
        if (button.isEnabled()) {
            NetUtils.paintDropShadow((Graphics2D)graphics, button, x, y, w, h);
        }
    }
}

