/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.toggle;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.toggle.Toggle;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.metal.MetalButtonUI;

public class ToggleUI
extends MetalButtonUI {
    private static final String PROPERTY_PREFIX = "Toggle.";
    public static final int KNOB_STATE_RIGHT = 0;
    public static final int KNOB_STATE_MOVING_LEFT = 1;
    public static final int KNOB_STATE_LEFT = 2;
    public static final int KNOB_STATE_MOVING_RIGHT = 3;
    private int knobState = 2;
    private static final double DURATION = 150.0;
    private static final int TIMER_DELAY = 10;
    private int myKnobXPosition;
    private int myPixelsPerUpdate;
    private Timer myAnimationTimer;
    private BasicToggleListener myToggleListener;

    public static ComponentUI createUI(JComponent comp) {
        return new ToggleUI();
    }

    @Override
    public void installDefaults(AbstractButton button) {
        super.installDefaults(button);
        NetUtils.setCursor(button);
        button.setRolloverEnabled(true);
        button.setOpaque(false);
        LookAndFeel.installBorder(button, "Toggle.border");
        NetUtils.setMarginAndFont(button, PROPERTY_PREFIX);
        this.myAnimationTimer = new Timer(10, new ToggleKnobListener(button));
        this.myAnimationTimer.setCoalesce(false);
    }

    @Override
    public void installListeners(AbstractButton b) {
        super.installListeners(b);
        b.addKeyListener(this.myToggleListener);
    }

    @Override
    public void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        b.removeKeyListener(this.myToggleListener);
    }

    public void setState(int state) {
        if (this.knobState != state) {
            this.knobState = state;
        }
    }

    public int getState() {
        return this.knobState;
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton btn, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton comp) {
    }

    @Override
    protected void paintText(Graphics g, JComponent comp, Rectangle textRect, String text) {
        AbstractButton button = (AbstractButton)comp;
        ButtonModel model = button.getModel();
        FontMetrics fontMetrics = g.getFontMetrics();
        int mnemIndex = button.getDisplayedMnemonicIndex();
        Color textColor = NetTheme.getTextShadowColor();
        Color offsetColor = UIManager.getColor("Toggle.textColor");
        int offset = -1;
        if (model.isEnabled()) {
            g.setColor(button.getForeground());
            NetUtils.paintText(g, text, mnemIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fontMetrics.getAscent() + this.getTextShiftOffset(), textColor, offsetColor, offset);
        } else {
            textColor = UIManager.getColor("Toggle.disabledText");
            NetUtils.paintText(g, text, mnemIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fontMetrics.getAscent() + this.getTextShiftOffset(), textColor, null, offset);
        }
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton button) {
        this.myToggleListener = new BasicToggleListener(button, PROPERTY_PREFIX);
        return this.myToggleListener;
    }

    @Override
    public void update(Graphics g, JComponent comp) {
        NetLookAndFeel.toggleTextAntialiasing(g);
        AbstractButton btn = (AbstractButton)comp;
        ButtonModel model = btn.getModel();
        Toggle toggle = (Toggle)comp;
        boolean isEnabled = model.isEnabled();
        boolean isKnobStateLeft = this.knobState == 2;
        boolean isKnobStateMovingRight = this.knobState == 3;
        Shape shape = g.getClip();
        if (!this.myAnimationTimer.isRunning()) {
            int xPosition = isKnobStateLeft ? 10 : 0;
            g.clipRect(xPosition, 0, comp.getWidth() - 10, comp.getHeight());
            int n = this.myKnobXPosition = isKnobStateLeft ? 2 : comp.getWidth() / 2;
        }
        String gradient = toggle.isAlternate() ? (isEnabled ? PROPERTY_PREFIX + (isKnobStateLeft || isKnobStateMovingRight ? "onGradient" : "offGradient") : PROPERTY_PREFIX + (isKnobStateLeft ? "disabledOnGradient" : "disabledOffGradient")) : PROPERTY_PREFIX + (isEnabled ? "normalGradient" : "disabledNormalGradient");
        GradientUtils.drawVerticalGradient(comp, g, gradient, NetUtils.getButtonOutlineForFill(comp));
        this.paint(g, comp);
        g.setClip(shape);
        gradient = PROPERTY_PREFIX + (model.isPressed() ? "knobPressedGradient" : "knobGradient");
        RectangularShape knob = NetUtils.getOutline(btn, this.myKnobXPosition, 1, comp.getWidth() / 2 - 2, comp.getHeight() - 4);
        GradientUtils.drawVerticalGradient(comp, g, gradient, (Shape)knob);
    }

    protected int getKnobXPosition() {
        return this.myKnobXPosition;
    }

    protected void setKnobXPosition(int knobXPosition) {
        this.myKnobXPosition = knobXPosition;
    }

    private int getPixelsPerUpdate() {
        return this.myPixelsPerUpdate;
    }

    private void setPixelsPerUpdate(int pixelsPerUpdate) {
        this.myPixelsPerUpdate = pixelsPerUpdate;
    }

    public Timer getAnimationTimer() {
        return this.myAnimationTimer;
    }

    private void moveToLeft() {
        int knobXPositionGoal = 2;
        if (this.myKnobXPosition <= knobXPositionGoal) {
            this.setState(2);
            this.myAnimationTimer.stop();
            return;
        }
        this.myKnobXPosition -= this.myPixelsPerUpdate;
        if (this.myKnobXPosition < knobXPositionGoal) {
            this.myKnobXPosition = knobXPositionGoal;
        }
    }

    private void moveToRight(Toggle toggle) {
        int knobXPositionGoal = toggle.getWidth() / 2;
        if (this.myKnobXPosition >= knobXPositionGoal) {
            this.setState(0);
            this.myAnimationTimer.stop();
            return;
        }
        this.myKnobXPosition += this.myPixelsPerUpdate;
        if (this.myKnobXPosition > knobXPositionGoal) {
            this.myKnobXPosition = knobXPositionGoal;
        }
    }

    protected static class BasicToggleListener
    extends BasicButtonListener
    implements KeyListener {
        private String myPropertyPrefix;
        private Toggle myToggle;

        public BasicToggleListener(AbstractButton btn, String propertyPrefix) {
            super(btn);
            this.myToggle = (Toggle)btn;
            this.myPropertyPrefix = propertyPrefix;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            JComponent source = (JComponent)event.getSource();
            String propertyName = event.getPropertyName();
            if ("JComponent.sizeVariant".equals(propertyName) && source instanceof AbstractButton) {
                NetUtils.setMarginAndFont((AbstractButton)source, this.myPropertyPrefix);
            }
            source.revalidate();
            source.repaint();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 32) {
                this.changeState();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            ButtonModel model = b.getModel();
            if (model.isArmed()) {
                this.changeState();
                model.setPressed(false);
                model.setArmed(false);
            } else {
                model.setPressed(false);
            }
        }

        public void changeState() {
            ToggleUI ui = (ToggleUI)this.myToggle.getUI();
            Timer animationTimer = ui.getAnimationTimer();
            if (!animationTimer.isRunning() && this.myToggle.isEnabled()) {
                switch (ui.getState()) {
                    case 2: {
                        ui.setKnobXPosition(2);
                        ui.setState(3);
                        break;
                    }
                    case 0: {
                        ui.setKnobXPosition(this.myToggle.getWidth() / 2);
                        ui.setState(1);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (ui.getPixelsPerUpdate() == 0) {
                    ui.setPixelsPerUpdate((int)Math.ceil(150.0 / ((double)this.myToggle.getWidth() / 2.0 - 2.0)));
                }
                animationTimer.start();
            }
        }
    }

    protected static class ToggleKnobListener
    implements ActionListener {
        private Toggle myToggle;

        public ToggleKnobListener(AbstractButton button) {
            this.myToggle = (Toggle)button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ToggleUI ui = (ToggleUI)this.myToggle.getUI();
            switch (ui.getState()) {
                case 3: {
                    ui.moveToRight(this.myToggle);
                    break;
                }
                case 1: {
                    ui.moveToLeft();
                    break;
                }
                default: {
                    return;
                }
            }
            this.myToggle.repaint();
        }
    }
}

