/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.tree;

import com.nokia.widgets.search.SearchEvent;
import com.nokia.widgets.search.SearchListener;
import com.nokia.widgets.text.PTextField;
import com.nokia.widgets.tree.ParentNodeResolver;
import com.nokia.widgets.util.WidgetResources;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractSearchTextField
extends PTextField {
    protected Set<SearchListener> myTreeSearchListeners = new HashSet<SearchListener>();
    protected SearchEvent mySearchEvent;
    protected Timer myTimer = null;
    protected int myMaxSearchCount = 200;
    protected int myAutoDelay = 400;
    private ParentNodeResolver myParentNodeResolver = new TreeNodeParentResolver();

    public AbstractSearchTextField() {
        super(10);
        this.setSearchField(true);
        this.setClearable(true);
        this.setAutoDelay(400);
        this.setSizeVariant("small");
        this.setPrompt(WidgetResources.getString("Search_Text"));
        this.addActionListener(this.createSearchAction());
        this.addDocumentListener(new DocumentHandler());
    }

    public void addSearchListener(SearchListener listener) {
        if (listener != null) {
            this.myTreeSearchListeners.add(listener);
        }
    }

    public void removeSearchListener(SearchListener listener) {
        this.myTreeSearchListeners.remove(listener);
    }

    public void setAutoDelay(int delay) {
        this.myAutoDelay = delay;
        if (delay < 0) {
            this.myTimer.stop();
            this.myTimer = null;
        } else if (this.myTimer == null) {
            this.myTimer = new Timer(delay, this.createSearchAction());
            this.myTimer.setRepeats(false);
        } else {
            this.myTimer.setDelay(delay);
        }
    }

    protected void fireSearchStarted() {
        for (SearchListener listener : this.myTreeSearchListeners) {
            listener.searchStarted(this.mySearchEvent);
        }
    }

    protected void fireSearchFinished() {
        for (SearchListener listener : this.myTreeSearchListeners) {
            listener.searchFinished(this.mySearchEvent);
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.isOnClearIcon(event.getPoint())) {
            return WidgetResources.getString("ClearSearchButton_TooltipText");
        }
        return super.getToolTipText(event);
    }

    public void setParentNodeResolver(ParentNodeResolver parentNodeResolver) {
        ParentNodeResolver oldValue = this.myParentNodeResolver;
        this.myParentNodeResolver = parentNodeResolver;
        this.firePropertyChange("parentNodeResolver", oldValue, this.myParentNodeResolver);
    }

    protected Object getParentNode(Object node) {
        return this.myParentNodeResolver.getParentNode(node);
    }

    protected TreePath getPathToRoot(Object node) {
        return new TreePath(this.getPathToRoot(node, 0));
    }

    private Object[] getPathToRoot(Object node, int depth) {
        Object[] result;
        int tempDepth = depth;
        if (node == null) {
            if (tempDepth == 0) {
                return null;
            }
            result = new Object[tempDepth];
        } else {
            result = this.getPathToRoot(this.getParentNode(node), ++tempDepth);
            result[result.length - tempDepth] = node;
        }
        return result;
    }

    protected int getMaxSearchCount() {
        return this.myMaxSearchCount;
    }

    public void setMaxSearchCount(int maxSearchCount) {
        this.myMaxSearchCount = maxSearchCount;
    }

    protected abstract ActionListener createSearchAction();

    private final class DocumentHandler
    implements DocumentListener {
        private DocumentHandler() {
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (AbstractSearchTextField.this.getText() == null || AbstractSearchTextField.this.getText().length() == 0 || AbstractSearchTextField.this.myAutoDelay == 0) {
                AbstractSearchTextField.this.createSearchAction().actionPerformed(new ActionEvent(this, 1, ""));
            } else if (AbstractSearchTextField.this.myTimer != null) {
                AbstractSearchTextField.this.myTimer.restart();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.removeUpdate(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.removeUpdate(e);
        }
    }

    protected class TreeNodeParentResolver
    implements ParentNodeResolver {
        protected TreeNodeParentResolver() {
        }

        @Override
        public TreeNode getParentNode(Object node) {
            return node instanceof TreeNode ? ((TreeNode)node).getParent() : null;
        }
    }
}

