/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.tree;

import com.nokia.widgets.text.AbstractSearchTextField;
import com.nokia.widgets.tree.ParentNodeResolver;
import java.awt.Component;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeSearchTextField
extends AbstractSearchTextField {
    private ParentNodeResolver myParentNodeResolver = new TreeNodeParentResolver();

    public AbstractTreeSearchTextField(Component comp) {
        super(comp);
    }

    public void setParentNodeResolver(ParentNodeResolver parentNodeResolver) {
        ParentNodeResolver oldValue = this.myParentNodeResolver;
        this.myParentNodeResolver = parentNodeResolver;
        this.firePropertyChange("parentNodeResolver", oldValue, this.myParentNodeResolver);
    }

    protected Object getParentNode(Object node) {
        return this.myParentNodeResolver.getParentNode(node);
    }

    protected TreePath getPathToRoot(Object node) {
        return new TreePath(this.getPathToRoot(node, 0));
    }

    private Object[] getPathToRoot(Object node, int depth) {
        Object[] result;
        int tempDepth = depth;
        if (node == null) {
            if (tempDepth == 0) {
                return null;
            }
            result = new Object[tempDepth];
        } else {
            result = this.getPathToRoot(this.getParentNode(node), ++tempDepth);
            result[result.length - tempDepth] = node;
        }
        return result;
    }

    protected class TreeNodeParentResolver
    implements ParentNodeResolver {
        protected TreeNodeParentResolver() {
        }

        @Override
        public TreeNode getParentNode(Object node) {
            return node instanceof TreeNode ? ((TreeNode)node).getParent() : null;
        }
    }
}

