/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.tree;

import com.nokia.laf.util.NetUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;

public class PDefaultTreeCellRenderer
extends DefaultTreeCellRenderer {
    protected boolean myRollovered = false;
    private boolean myUpdateAutoTooltipOnPaint = false;
    private static Rectangle theIconRect = new Rectangle();
    private static Rectangle theViewRect = new Rectangle();
    private Rectangle myTextRect = new Rectangle();
    private JTree myTree;

    public PDefaultTreeCellRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean isFocus) {
        super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, isFocus);
        this.myTree = tree;
        Color selectedColor = null;
        selectedColor = isSelected ? (isFocus ? UIManager.getColor("Tree.selectionBackground") : UIManager.getColor("Tree.selectedNonFocusBackground")) : UIManager.getColor("Tree.textBackground");
        this.setBackground(selectedColor);
        Point rolloveredRow = (Point)tree.getClientProperty("BlueTouch.rolloveredCell");
        this.myRollovered = rolloveredRow != null ? row == (int)rolloveredRow.getX() && tree.isEnabled() : false;
        this.myUpdateAutoTooltipOnPaint = this.myRollovered;
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myUpdateAutoTooltipOnPaint) {
            Insets insets = this.getInsets();
            PDefaultTreeCellRenderer.theViewRect.x = insets.left;
            PDefaultTreeCellRenderer.theViewRect.y = insets.top;
            PDefaultTreeCellRenderer.theViewRect.width = this.getWidth() - insets.left - insets.right;
            PDefaultTreeCellRenderer.theViewRect.height = this.getHeight() - insets.top - insets.bottom;
            NetUtils.resetRectangle(theIconRect);
            NetUtils.resetRectangle(this.myTextRect);
            FontMetrics fm = this.getFontMetrics(this.getFont());
            NetUtils.layoutCompoundLabel(this, fm, this.getText(), this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), theViewRect, theIconRect, this.myTextRect, this.getIconTextGap(), fm.getHeight(), false);
            this.setAutomaticTooltip();
        }
    }

    private void setAutomaticTooltip() {
        if (!this.isAutoTooltipInUse()) {
            return;
        }
        if (!this.myTree.getVisibleRect().contains(SwingUtilities.convertRectangle(this, this.myTextRect, this.myTree))) {
            this.setToolTipText(this.getText());
        } else {
            this.setToolTipText(null);
        }
    }

    private boolean isAutoTooltipInUse() {
        if (this.myTree != null && Boolean.FALSE.equals(this.myTree.getClientProperty("OrangeTouch.automaticTooltipEnabled"))) {
            return false;
        }
        return !Boolean.FALSE.equals(this.getClientProperty("OrangeTouch.automaticTooltipEnabled"));
    }

    public static class UIResource
    extends PDefaultTreeCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

