/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import javax.swing.tree.TreeModel;

public class PreorderNodeIterator
implements Iterator<Object> {
    private Stack<Iterator<Object>> myStack;
    public TreeModel myTreeModel;

    public PreorderNodeIterator(TreeModel treeModel) {
        ArrayList<Object> v = new ArrayList<Object>(1);
        this.myTreeModel = treeModel;
        v.add(treeModel.getRoot());
        this.myStack = new Stack();
        this.myStack.push(v.iterator());
    }

    @Override
    public boolean hasNext() {
        return !this.myStack.empty() && this.myStack.peek().hasNext();
    }

    @Override
    public Object next() {
        Iterator<Object> iter = this.myStack.peek();
        Object node = iter.next();
        ChildIterator children = new ChildIterator(node);
        if (!iter.hasNext()) {
            this.myStack.pop();
        }
        if (children.hasNext()) {
            this.myStack.push(children);
        }
        return node;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("PreorderNodeIterator does not support remove()");
    }

    class ChildIterator
    implements Iterator<Object> {
        private Object myNode;
        private int myCurrentChild = 0;

        public ChildIterator(Object node) {
            this.myNode = node;
        }

        @Override
        public boolean hasNext() {
            return this.myCurrentChild < PreorderNodeIterator.this.myTreeModel.getChildCount(this.myNode);
        }

        @Override
        public Object next() {
            return PreorderNodeIterator.this.myTreeModel.getChild(this.myNode, this.myCurrentChild++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("ChildIterator does not support remove()");
        }
    }
}

