/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.tree;

import com.nokia.widgets.search.SearchEvent;
import com.nokia.widgets.search.SearchListener;
import com.nokia.widgets.text.PTextField;
import com.nokia.widgets.text.search.SearchBar;
import com.nokia.widgets.tree.TreeHighlight;
import com.nokia.widgets.tree.TreeSearchTextField;
import com.nokia.widgets.util.WidgetResources;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ListIterator;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.text.Position;
import javax.swing.tree.TreePath;

public class TreeSearchBar
extends SearchBar
implements SearchListener {
    private JTree myTree;
    protected TreeSearchTextField mySearchTextField;
    private boolean mySelectionFollowsMatch = true;
    ListIterator<TreeHighlight> mySearchHits;

    public TreeSearchBar(JTree tree) {
        this.myTree = tree;
        this.instantiateSearchTextField();
        this.buildUI();
    }

    public TreeSearchTextField getSearchField() {
        return this.mySearchTextField;
    }

    public void setSelectionFollowsMatch(boolean selectionFollowsMatch) {
        this.mySelectionFollowsMatch = selectionFollowsMatch;
    }

    public void clearSearchResults() {
        this.updateMatchesCount();
        this.mySearchHits = null;
        this.myPreviousSearchDirection = null;
        this.myTree.putClientProperty("OrangeTouch.treeEmphasizedHighlight", null);
        this.myTree.putClientProperty("OrangeTouch.highlightText", null);
        this.myTree.repaint();
    }

    @Override
    public void searchFinished(SearchEvent event) {
        this.myMatchCount = this.mySearchTextField.getMatches().size();
        this.setSearchButtonsEnabled(this.myMatchCount > 0);
        if (this.mySearchTextField.getText().isEmpty()) {
            this.myTree.putClientProperty("OrangeTouch.treeEmphasizedHighlight", null);
        }
        this.updateMatchesCount();
        this.setPreviousSearchDirection(null);
        this.myTree.repaint();
    }

    @Override
    public void searchStarted(SearchEvent event) {
        this.mySearchHits = null;
    }

    @Override
    public void setMaxSearchCount(int maxSearchCount) {
        this.myMaxSearchCount = maxSearchCount;
        this.mySearchTextField.setMaxSearchCount(maxSearchCount);
    }

    public Position.Bias getPreviousSearchDirection() {
        return this.myPreviousSearchDirection;
    }

    public ListIterator<TreeHighlight> getSearchHits() {
        return this.mySearchHits;
    }

    public boolean getSelectionFollowsMatch() {
        return this.mySelectionFollowsMatch;
    }

    public JTree getTree() {
        return this.myTree;
    }

    @Override
    public void setPreviousSearchDirection(Position.Bias myBias) {
        this.myPreviousSearchDirection = myBias;
    }

    @Override
    protected PTextField getPTextField() {
        return this.mySearchTextField;
    }

    public void instantiateSearchTextField() {
        this.mySearchTextField = new TreeSearchTextField(this.myTree);
        this.mySearchTextField.addSearchListener(this);
    }

    protected void search(Position.Bias bias) {
        Position.Bias previousDirection = this.getPreviousSearchDirection();
        boolean searchDirectionChanged = previousDirection != null && !previousDirection.equals(bias);
        this.setPreviousSearchDirection(bias);
        if (this.getSearchHits() == null) {
            this.setSearchHits(this.getSearchField().getMatches().listIterator());
        }
        TreeHighlight nextMatch = this.getNextMatch(bias, searchDirectionChanged);
        this.setMatchVisible(nextMatch);
        this.getTree().repaint();
    }

    private void setMatchVisible(TreeHighlight match) {
        JTree tree = this.getTree();
        tree.putClientProperty("OrangeTouch.treeEmphasizedHighlight", match);
        if (match == null) {
            return;
        }
        TreePath pathToMatch = match.getPath();
        tree.expandPath(pathToMatch.getParentPath());
        if (this.getSelectionFollowsMatch()) {
            tree.setSelectionPath(pathToMatch);
        }
        match.scrollToVisible(tree);
    }

    private TreeHighlight getNextMatch(Position.Bias bias, boolean searchDirectionChanged) {
        TreeHighlight nextMatch = null;
        if (bias == Position.Bias.Forward) {
            nextMatch = this.nextForwardMatch();
            if (searchDirectionChanged) {
                nextMatch = this.nextForwardMatch();
            }
        } else {
            nextMatch = this.nextBackwardMatch();
            if (searchDirectionChanged) {
                nextMatch = this.nextBackwardMatch();
            }
        }
        return nextMatch;
    }

    private TreeHighlight nextBackwardMatch() {
        ListIterator<TreeHighlight> searchHits = this.getSearchHits();
        if (searchHits.hasPrevious()) {
            return searchHits.previous();
        }
        List<TreeHighlight> matches = this.getSearchField().getMatches();
        this.setSearchHits(matches.listIterator(matches.size()));
        searchHits = this.getSearchHits();
        if (searchHits.hasPrevious()) {
            return searchHits.previous();
        }
        return null;
    }

    private TreeHighlight nextForwardMatch() {
        ListIterator<TreeHighlight> searchHits = this.getSearchHits();
        if (searchHits.hasNext()) {
            return searchHits.next();
        }
        List<TreeHighlight> matches = this.getSearchField().getMatches();
        this.setSearchHits(matches.listIterator());
        searchHits = this.getSearchHits();
        if (searchHits.hasNext()) {
            return searchHits.next();
        }
        return null;
    }

    public void setSearchHits(ListIterator<TreeHighlight> iterator) {
        this.mySearchHits = iterator;
    }

    @Override
    protected void nextMatchAction(ActionEvent e) {
        this.search(Position.Bias.Forward);
    }

    @Override
    protected void previousMatchAction(ActionEvent e) {
        this.search(Position.Bias.Backward);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleTreeSearchBar();
        }
        return this.accessibleContext;
    }

    protected class AccessibleTreeSearchBar
    extends JComponent.AccessibleJComponent {
        protected AccessibleTreeSearchBar() {
            super(TreeSearchBar.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TOOL_BAR;
        }

        @Override
        public String getAccessibleName() {
            return this.accessibleName == null ? WidgetResources.getString("TreeSearchBar.Default.AccessibleName") : this.accessibleName;
        }

        @Override
        public String getAccessibleDescription() {
            return this.accessibleDescription == null ? WidgetResources.getString("TreeSearchBar.Default.AccessibleDescription") : this.accessibleDescription;
        }
    }
}

