/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.tree;

import com.nokia.widgets.tree.AbstractTreeSearchTextField;
import com.nokia.widgets.tree.PreorderNodeIterator;
import com.nokia.widgets.tree.TreeHighlight;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class TreeSearchTextField
extends AbstractTreeSearchTextField {
    protected JTree myTree;
    protected List<TreeHighlight> myMatches = new LinkedList<TreeHighlight>();

    public TreeSearchTextField(JTree tree) {
        super(tree);
        this.myTree = tree;
    }

    public List<TreeHighlight> getMatches() {
        return this.myMatches;
    }

    public JTree getTree() {
        return this.myTree;
    }

    public void search() {
        this.fireSearchStarted();
        this.myMatches.clear();
        this.myTree.stopEditing();
        this.myTree.putClientProperty("OrangeTouch.treeEmphasizedHighlight", null);
        String searchText = this.getText();
        this.myTree.putClientProperty("OrangeTouch.highlightText", searchText);
        if (searchText == null || searchText.length() == 0) {
            this.myTree.repaint();
            this.fireSearchFinished();
            return;
        }
        searchText = searchText.replaceAll("(\\p{Punct})", "\\\\$1");
        Pattern pattern = Pattern.compile(searchText.toUpperCase());
        try {
            this.collectMatches(this.createNodeIterator(), pattern);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.fireSearchFinished();
    }

    @Override
    protected ActionListener createSearchAction() {
        return new SearchAction();
    }

    protected Iterator<?> createNodeIterator() {
        return new PreorderNodeIterator(this.myTree.getModel());
    }

    protected void collectMatches(Iterator<?> nodes, Pattern pattern) {
        TreePath selectionPath = this.myTree.getSelectionPath();
        String regex = pattern.pattern();
        String unescaped = regex.replaceAll("(\\\\)(\\p{Punct})", "$2");
        while (nodes.hasNext()) {
            if (this.myMaxSearchCount != -1 && this.getMatches().size() > this.myMaxSearchCount) break;
            Object nextNode = nodes.next();
            if (!this.myTree.isRootVisible() && this.getParentNode(nextNode) == null) continue;
            TreePath path = this.getPathToRoot(nextNode);
            int row = this.myTree.getRowForPath(path);
            String text = this.myTree.convertValueToText(nextNode, this.myTree.isRowSelected(row), this.myTree.isExpanded(row), true, row, false);
            boolean isFirstMatchInNode = true;
            Matcher m = pattern.matcher(text.toUpperCase());
            while (m.find()) {
                this.getMatches().add(new TreeHighlight(path, unescaped, m.start()));
                if (!isFirstMatchInNode) continue;
                this.myTree.expandPath(path.getParentPath());
                isFirstMatchInNode = false;
            }
        }
        if (this.getMatches().size() > 0) {
            TreeHighlight firstMatch = this.getMatches().get(0);
            this.myTree.scrollPathToVisible(firstMatch.getPath());
        }
        if (selectionPath != null) {
            this.myTree.setSelectionPath(selectionPath);
        }
    }

    public final class SearchAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            TreeSearchTextField.this.search();
        }
    }
}

