/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.tree;

import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeUtils {
    public static void expandAll(JTree tree) {
        TreeModel model = tree.getModel();
        if (model != null && model.getRoot() != null) {
            TreeUtils.expand(tree, new TreePath(model.getRoot()), true);
        }
    }

    public static void collapseAll(JTree tree) {
        TreeModel model = tree.getModel();
        if (model != null && model.getRoot() != null) {
            TreeUtils.expand(tree, new TreePath(model.getRoot()), false);
        }
    }

    public static void expand(JTree tree, TreePath parent, boolean expand) {
        TreeUtils.expand(tree, parent, expand, Integer.MAX_VALUE);
    }

    public static void expand(JTree tree, TreePath parent, boolean expand, int level) {
        if (level > 1) {
            Object node = parent.getLastPathComponent();
            TreeModel model = tree.getModel();
            int childCount = model.getChildCount(node);
            if (childCount >= 0) {
                int idx = 0;
                while (idx < childCount) {
                    Object nextChild = model.getChild(node, idx);
                    TreePath path = parent.pathByAddingChild(nextChild);
                    TreeUtils.expand(tree, path, expand, level - 1);
                    ++idx;
                }
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public static int getTreeNodeCount(JTree tree) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        return TreeUtils.getNodeChildrenCount(tree.getModel(), root);
    }

    private static int getNodeChildrenCount(TreeModel model, Object node) {
        int count = 1;
        int childCount = model.getChildCount(node);
        int i = 0;
        while (i < childCount) {
            count += TreeUtils.getNodeChildrenCount(model, model.getChild(node, i));
            ++i;
        }
        return count;
    }

    public static int getDepthOfFirstSharedAncestorNode(TreePath path1, TreePath path2) {
        int minPathCount = Math.min(path1.getPathCount(), path2.getPathCount());
        int depth = 0;
        while (depth < minPathCount) {
            if (!path1.getPathComponent(depth).equals(path2.getPathComponent(depth))) {
                return depth - 1;
            }
            ++depth;
        }
        return minPathCount - 1;
    }

    public static TreePath getSubPath(TreePath path, int size) {
        Object[] result = new Object[size];
        System.arraycopy(path.getPath(), 0, result, 0, size);
        return new TreePath(result);
    }
}

