/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.treetable;

import com.nokia.widgets.treetable.TreeTableModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeTableModel
implements TreeTableModel {
    protected Object myRoot;
    protected List<TreeModelListener> myListeners = new ArrayList<TreeModelListener>();

    public AbstractTreeTableModel(Object root) {
        this.myRoot = root;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        int i = 0;
        while (i < this.getChildCount(parent)) {
            if (this.getChild(parent, i).equals(child)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return this.myRoot;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public Class getColumnClass(int column) {
        return Object.class;
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        if (listener != null && !this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        this.myListeners.remove(listener);
    }

    @Override
    public void valueForPathChanged(TreePath arg0, Object arg1) {
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return this.getColumnClass(column) == TreeTableModel.class;
    }

    protected TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
        TreeNode[] retNodes;
        int steps = depth;
        if (aNode == null) {
            if (steps == 0) {
                return null;
            }
            retNodes = new TreeNode[steps];
        } else {
            retNodes = aNode == this.myRoot ? new TreeNode[steps] : this.getPathToRoot(aNode.getParent(), ++steps);
            retNodes[retNodes.length - steps] = aNode;
        }
        return retNodes;
    }

    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        for (TreeModelListener listener : this.myListeners) {
            TreeModelEvent event = new TreeModelEvent(source, path, childIndices, children);
            listener.treeNodesChanged(event);
        }
    }

    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        for (TreeModelListener listener : this.myListeners) {
            TreeModelEvent event = new TreeModelEvent(source, path, childIndices, children);
            listener.treeNodesInserted(event);
        }
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        for (TreeModelListener listener : this.myListeners) {
            TreeModelEvent event = new TreeModelEvent(source, path, childIndices, children);
            listener.treeNodesRemoved(event);
        }
    }

    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        for (TreeModelListener listener : this.myListeners) {
            TreeModelEvent event = new TreeModelEvent(source, path, childIndices, children);
            listener.treeStructureChanged(event);
        }
    }

    protected void treeNodesChanged(TreeNode node, int[] childIndices) {
        if (node != null && childIndices != null) {
            ArrayList<TreeNode> children = new ArrayList<TreeNode>();
            int[] nArray = childIndices;
            int n = childIndices.length;
            int n2 = 0;
            while (n2 < n) {
                Integer index = nArray[n2];
                children.add(node.getChildAt(index));
                ++n2;
            }
            this.fireTreeNodesChanged(node, this.getPathToRoot(node, 0), childIndices, children.toArray());
        } else if (node == this.getRoot()) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(node, 0), null, null);
        }
    }

    protected void treeNodeChanged(TreeNode node) {
        if (node != null) {
            TreeNode parent = node.getParent();
            if (parent != null) {
                if (parent.getIndex(node) != -1) {
                    int[] childIndices = new int[]{parent.getIndex(node)};
                    this.treeNodesChanged(parent, childIndices);
                }
            } else if (node == this.getRoot()) {
                this.treeNodesChanged(node, null);
            }
        }
    }

    protected void treeNodesRemoved(TreeNode parent, int[] childIndices) {
        if (parent != null && childIndices != null) {
            ArrayList<TreeNode> children = new ArrayList<TreeNode>();
            int[] nArray = childIndices;
            int n = childIndices.length;
            int n2 = 0;
            while (n2 < n) {
                Integer index = nArray[n2];
                children.add(parent.getChildAt(index));
                ++n2;
            }
            this.fireTreeNodesRemoved(parent, this.getPathToRoot(parent, 0), childIndices, children.toArray());
        }
    }

    protected void treeNodeRemoved(TreeNode node) {
        if (node.getParent() != null) {
            TreeNode parent = node.getParent();
            int[] childIndices = new int[]{parent.getIndex(node)};
            Object[] children = new Object[]{node};
            this.fireTreeNodesRemoved(parent, this.getPathToRoot(parent, 0), childIndices, children);
        }
    }

    protected void treeNodeRemoved(TreeNode node, TreeNode parent, int index) {
        if (parent != null) {
            int[] childIndices = new int[]{index};
            Object[] children = new Object[]{node};
            this.fireTreeNodesRemoved(parent, this.getPathToRoot(parent, 0), childIndices, children);
        }
    }

    protected void treeNodesInserted(TreeNode node, int[] childIndices) {
        if (node != null && childIndices != null) {
            ArrayList<TreeNode> children = new ArrayList<TreeNode>();
            int[] nArray = childIndices;
            int n = childIndices.length;
            int n2 = 0;
            while (n2 < n) {
                Integer index = nArray[n2];
                children.add(node.getChildAt(index));
                ++n2;
            }
            this.fireTreeNodesInserted(node, this.getPathToRoot(node, 0), childIndices, children.toArray());
        }
    }

    protected void treeNodeInserted(TreeNode parent, TreeNode child) {
        if (parent != null && child != null) {
            this.fireTreeNodesInserted(parent, this.getPathToRoot(parent, 0), new int[]{parent.getIndex(child)}, new Object[]{child});
        }
    }

    protected void treeNodeStructureChanged(TreeNode node) {
        this.fireTreeStructureChanged(this, this.getPathToRoot(node, 0), null, null);
    }
}

