/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.treetable;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTableUI;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.table.PSortableTableModel;
import com.nokia.widgets.table.PTable;
import com.nokia.widgets.treetable.TreeTableCellEditor;
import com.nokia.widgets.treetable.TreeTableHighlight;
import com.nokia.widgets.treetable.TreeTableModel;
import com.nokia.widgets.treetable.TreeTableModelAdapter;
import com.nokia.widgets.treetable.TreeTableModelSorter;
import com.nokia.widgets.treetable.TreeTableRenderer;
import com.nokia.widgets.treetable.TreeTableTreeCellRenderer;
import com.nokia.widgets.util.NSNColors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public class TreeTable
extends PTable {
    private TreeTableRenderer myTree;
    private TreeTableModelAdapter myTreeTableModelAdapter;

    public TreeTable(TreeTableModel model) {
        this.putClientProperty("OrangeTouch.shouldAdjustSelection", Boolean.FALSE);
        this.myTree = this.createTreeTableRenderer(model);
        this.myTree.setRowHeight(this.getRowHeight());
        this.myTree.setCellRenderer(new TreeTableTreeCellRenderer(this));
        this.myTree.setSelectionModel(new TreeTableSelectionModel());
        this.myTreeTableModelAdapter = new TreeTableModelAdapter(model, this.myTree);
        this.setModel(this.myTreeTableModelAdapter);
        this.setDefaultRenderer(TreeTableModel.class, this.myTree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor(this.myTree, this));
        this.myTree.putClientProperty("JTree.lineStyle", "None");
        this.installKeyboardActions();
    }

    protected void installKeyboardActions() {
        this.getInputMap().put(KeyStroke.getKeyStroke("ctrl RIGHT"), "expandRow");
        this.getActionMap().put("expandRow", new ExpandCollapseAction(true));
        this.getInputMap().put(KeyStroke.getKeyStroke("ctrl LEFT"), "collapseRow");
        this.getActionMap().put("collapseRow", new ExpandCollapseAction(false));
        this.getInputMap().put(KeyStroke.getKeyStroke("F2"), "startEdit");
        this.getActionMap().put("startEdit", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = TreeTable.this.getSelectedRows();
                TreeTable.this.myTree.dispatchEvent(e);
                int selectedRow = TreeTable.this.getSelectedRow();
                TreeTable.this.editCellAt(selectedRow, 0);
                TreeTable.this.myTree.setSelectionRows(selectedRows);
            }

            @Override
            public boolean isEnabled() {
                return TreeTable.this.myTree.isEditable() && TreeTable.this.getSelectedColumn() == 0;
            }
        });
    }

    protected TreeTableRenderer createTreeTableRenderer(TreeTableModel model) {
        return new TreeTableRenderer(model, this);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setUI(new TreeTableUI());
    }

    public void scrollPathToVisible(TreePath path) {
        int row = this.getTree().getRowForPath(path);
        this.scrollRectToVisible(this.getCellRect(this.getViewRow(row), this.convertColumnIndexToView(0), false));
    }

    @Override
    public void setAlternate(boolean alternate) {
        super.setAlternate(alternate);
        this.myTree.setAlternate(alternate);
    }

    @Override
    public void setRowHeight(int height) {
        super.setRowHeight(height);
        if (this.myTree != null) {
            this.myTree.setRowHeight(height);
        }
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    @Override
    public int getViewRow(int modelRow) {
        if (modelRow < 0) {
            return modelRow;
        }
        if (this.getModel() instanceof PSortableTableModel) {
            return ((PSortableTableModel)this.getModel()).getSortedIndex(modelRow);
        }
        return modelRow;
    }

    @Override
    public int getModelRow(int viewRow) {
        if (viewRow < 0) {
            return viewRow;
        }
        if (this.getModel() instanceof PSortableTableModel) {
            return ((PSortableTableModel)this.getModel()).getOriginalIndex(viewRow);
        }
        return viewRow;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.getEditingColumn() != -1 && this.getColumnClass(this.editingColumn) == TreeTableModel.class) {
            Rectangle cell = this.getCellRect(this.editingRow, this.getEditingColumn(), false);
            Component component = this.getEditorComponent();
            component.setBounds(cell);
            component.validate();
        }
    }

    public TreeTableModel getTreeModel() {
        return TreeTable.getTreeModel(this.getModel());
    }

    static TreeTableModel getTreeModel(TableModel model) {
        if (model instanceof PSortableTableModel) {
            TreeTableModelAdapter modelAdapter = (TreeTableModelAdapter)((PSortableTableModel)model).getWrappedModel();
            return modelAdapter.getModel();
        }
        return ((TreeTableModelAdapter)model).getModel();
    }

    public void expandTree() {
        this.myTree.expandAll();
    }

    public void collapseTree() {
        this.myTree.collapseAll();
    }

    public void setTreeEditable(boolean editable) {
        TableCellEditor editor = this.getDefaultEditor(TreeTableModel.class);
        if (editor instanceof TreeTableCellEditor) {
            ((TreeTableCellEditor)editor).setTreeEditable(editable);
        }
    }

    public boolean isTreeEditable() {
        TableCellEditor editor = this.getDefaultEditor(TreeTableModel.class);
        if (editor instanceof TreeTableCellEditor) {
            return ((TreeTableCellEditor)editor).isTreeEditable();
        }
        return this.myTree.isEditable();
    }

    public JTree getTree() {
        return this.myTree;
    }

    public void setTreeCellRenderer(TreeTableTreeCellRenderer renderer) {
        this.myTree.setCellRenderer(renderer);
    }

    public void setSortable(boolean sortable) {
        this.myTreeTableModelAdapter.uninstall();
        this.myTreeTableModelAdapter = new TreeTableModelAdapter(this.getTreeModel(), this.myTree);
        if (sortable) {
            this.setModel(new TreeTableModelSorter(this.myTreeTableModelAdapter, this.myTree));
        } else {
            this.setModel(this.myTreeTableModelAdapter);
        }
    }

    public String convertValueToText(Object node, boolean selected, boolean expanded, boolean leaf, int row, int columnIndex, boolean hasFocus) {
        String sValue;
        if (this.getModel().getColumnClass(columnIndex) == TreeTableModel.class) {
            return this.myTree.convertValueToText(node, selected, expanded, leaf, row, hasFocus);
        }
        Object value = this.getTreeModel().getValueAt(node, columnIndex);
        if (value != null && (sValue = value.toString()) != null) {
            return sValue;
        }
        return "";
    }

    private final class ExpandCollapseAction
    extends AbstractAction {
        private boolean myExpand = false;

        public ExpandCollapseAction(boolean expand) {
            this.myExpand = expand;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selectedRows = TreeTable.this.getSelectedRows();
            int[] selectedColumns = TreeTable.this.getSelectedColumns();
            TreePath pathForRow = TreeTable.this.myTree.getPathForRow(TreeTable.this.getModelRow(TreeTable.this.getSelectedRow()));
            if (this.myExpand) {
                TreeTable.this.myTree.expandPath(pathForRow);
            } else {
                TreeTable.this.myTree.collapsePath(pathForRow);
            }
            int[] nArray = selectedRows;
            int n = selectedRows.length;
            int n2 = 0;
            while (n2 < n) {
                int row = nArray[n2];
                TreeTable.this.addRowSelectionInterval(row, row);
                ++n2;
            }
            nArray = selectedColumns;
            n = selectedColumns.length;
            n2 = 0;
            while (n2 < n) {
                int column = nArray[n2];
                TreeTable.this.addColumnSelectionInterval(column, column);
                ++n2;
            }
        }

        @Override
        public boolean isEnabled() {
            return TreeTable.this.getSelectedColumn() == 0;
        }
    }

    private class TreeTableSelectionModel
    extends DefaultTreeSelectionModel {
        public TreeTableSelectionModel() {
            TreeTable.this.setSelectionModel(this.listSelectionModel);
        }
    }

    protected class TreeTableUI
    extends NetTableUI {
        protected TreeTableUI() {
        }

        @Override
        protected Component prepareRenderer(TableCellRenderer renderer, int row, int column, boolean hasFocus) {
            Component result = super.prepareRenderer(renderer, row, column, hasFocus);
            Color cellBackground = result.getBackground();
            if ((cellBackground == null || cellBackground instanceof UIResource) && this.table.getColumnClass(column) == TreeTableModel.class) {
                cellBackground = this.isCellDisplaydAsEditable(this.table, row, column) || !this.isAlternate() ? NetLookAndFeel.getWhite() : (row % 2 == 0 ? UIManager.getColor("Table.UnEditableRowBackground1") : UIManager.getColor("Table.UnEditableRowBackground2"));
                result.setBackground(cellBackground);
            }
            if (result instanceof JComponent && column + 1 < this.table.getColumnCount() && this.table.getColumnClass(column + 1) == TreeTableModel.class) {
                ((JComponent)result).putClientProperty("Table.isRightEnd", true);
            }
            return result;
        }

        @Override
        protected boolean isCellDisplaydAsEditable(JTable jTable, int row, int column) {
            if (jTable.getColumnClass(column) == TreeTableModel.class) {
                return TreeTable.this.isTreeEditable();
            }
            return super.isCellDisplaydAsEditable(jTable, row, column);
        }

        @Override
        protected void addSingleHighlight(JLabel label, int row, int column) {
            TreeTableHighlight singleHighlight = (TreeTableHighlight)this.table.getClientProperty("OrangeTouch.tableEmphasizedHighlight");
            if (singleHighlight == null) {
                return;
            }
            int highlightedRow = ((TreeTable)this.table).getTree().getRowForPath(singleHighlight.getPath());
            if (this.table.getModel() instanceof PSortableTableModel) {
                highlightedRow = ((PSortableTableModel)this.table.getModel()).getSortedIndex(highlightedRow);
            }
            if (row == highlightedRow && column == this.table.convertColumnIndexToView(singleHighlight.getColumn())) {
                int index = singleHighlight.getIndex();
                String text = singleHighlight.getText();
                NetUtils.addHighlight(label, index, singleHighlight.getIndex() + text.length(), NSNColors.getPurple());
            }
        }
    }
}

