/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.treetable;

import com.nokia.widgets.table.PSortableTableModel;
import com.nokia.widgets.treetable.TreeTableModel;
import com.nokia.widgets.treetable.TreeTableRenderer;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class TreeTableCellEditor
extends DefaultCellEditor {
    private TreeTableRenderer myTree;
    private JTable myTable;
    private boolean isTreeEditable;

    public TreeTableCellEditor(TreeTableRenderer tree, JTable table) {
        super(new TreeTableTextField());
        this.myTree = tree;
        this.myTable = table;
    }

    @Override
    public boolean isCellEditable(EventObject eo) {
        if (eo instanceof MouseEvent) {
            MouseEvent e = (MouseEvent)eo;
            int i = 0;
            while (i < this.myTable.getColumnCount()) {
                if (this.myTable.getColumnClass(i) == TreeTableModel.class) {
                    int y = e.getY();
                    int x = e.getX() - this.myTable.getCellRect((int)0, (int)i, (boolean)true).x;
                    if (this.myTable.getModel() instanceof PSortableTableModel) {
                        PSortableTableModel model = (PSortableTableModel)this.myTable.getModel();
                        int row = this.myTree.getClosestRowForLocation(x, y);
                        Rectangle rowBounds = this.myTree.getRowBounds(row);
                        int originalRow = model.getOriginalIndex(row);
                        Rectangle originalRowBounds = this.myTree.getRowBounds(originalRow);
                        y += originalRowBounds.y - rowBounds.y;
                    }
                    MouseEvent me = new MouseEvent(this.myTree, e.getID(), e.getWhen(), e.getModifiers(), x, y, e.getClickCount(), e.isPopupTrigger());
                    this.myTree.dispatchEvent(me);
                    break;
                }
                ++i;
            }
            if (e.getClickCount() >= 3) {
                return this.isTreeEditable;
            }
        }
        return eo == null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Rectangle bounds = this.myTree.getRowBounds(row);
        int editableAreaOffset = bounds.x;
        TreeCellRenderer renderer = this.myTree.getCellRenderer();
        if (renderer instanceof DefaultTreeCellRenderer) {
            Object node = this.myTree.getPathForRow(row).getLastPathComponent();
            editableAreaOffset = this.myTree.getModel().isLeaf(node) ? (editableAreaOffset += ((DefaultTreeCellRenderer)renderer).getLeafIcon().getIconWidth()) : (this.myTree.isExpanded(row) ? (editableAreaOffset += ((DefaultTreeCellRenderer)renderer).getOpenIcon().getIconWidth()) : (editableAreaOffset += ((DefaultTreeCellRenderer)renderer).getClosedIcon().getIconWidth()));
            editableAreaOffset += ((DefaultTreeCellRenderer)renderer).getIconTextGap();
        }
        ((TreeTableTextField)this.getComponent()).setEditableAreaOffset(editableAreaOffset);
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public void setTreeEditable(boolean editable) {
        this.isTreeEditable = editable;
    }

    public boolean isTreeEditable() {
        return this.isTreeEditable;
    }

    private static class TreeTableTextField
    extends JTextField {
        private int myEditableAreaOffset;

        private TreeTableTextField() {
        }

        public void setEditableAreaOffset(int editableAreaOffset) {
            this.myEditableAreaOffset = editableAreaOffset;
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            int xStart = Math.max(x, this.myEditableAreaOffset);
            super.setBounds(xStart, y, w - (xStart - x), h);
        }
    }
}

