/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.treetable;

import com.nokia.widgets.treetable.TreeTableModel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;

public class TreeTableModelAdapter
extends AbstractTableModel {
    private TreeTableModel myModel;
    private JTree myTree;
    private TreeExpansionListener myTreeExpansionListener = new TreeExpansionListener(){

        @Override
        public void treeCollapsed(TreeExpansionEvent arg0) {
            TreeTableModelAdapter.this.fireTableDataChanged();
        }

        @Override
        public void treeExpanded(TreeExpansionEvent arg0) {
            TreeTableModelAdapter.this.fireTableDataChanged();
        }
    };
    private TreeModelListener myTreeModelListener = new TreeModelListener(){

        @Override
        public void treeNodesChanged(TreeModelEvent arg0) {
            TreeTableModelAdapter.this.tableDataChanged();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent arg0) {
            TreeTableModelAdapter.this.tableDataChanged();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent arg0) {
            TreeTableModelAdapter.this.tableDataChanged();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent arg0) {
            TreeTableModelAdapter.this.tableDataChanged();
        }
    };

    public TreeTableModelAdapter(TreeTableModel model, JTree tree) {
        this.myModel = model;
        this.myTree = tree;
        this.addListeners();
    }

    private void addListeners() {
        this.myTree.addTreeExpansionListener(this.myTreeExpansionListener);
        this.myModel.addTreeModelListener(this.myTreeModelListener);
    }

    private void removeListeners() {
        this.myTree.removeTreeExpansionListener(this.myTreeExpansionListener);
        this.myModel.removeTreeModelListener(this.myTreeModelListener);
    }

    public void uninstall() {
        this.removeListeners();
    }

    @Override
    public int getColumnCount() {
        return this.myModel.getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return this.myModel.getColumnName(column);
    }

    public Class getColumnClass(int column) {
        return this.myModel.getColumnClass(column);
    }

    @Override
    public int getRowCount() {
        return this.myTree.getRowCount();
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.myModel.getValueAt(this.getNodeAtRow(row), column);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        this.myModel.setValueAt(value, this.getNodeAtRow(row), column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.myModel.isCellEditable(this.getNodeAtRow(row), column);
    }

    public TreeTableModel getModel() {
        return this.myModel;
    }

    public Object getNodeAtRow(int row) {
        TreePath path = this.myTree.getPathForRow(row);
        return path.getLastPathComponent();
    }

    private void tableDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
    }
}

