/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.treetable;

import com.nokia.widgets.table.PTableModelComparator;
import com.nokia.widgets.table.PTableModelSorter;
import com.nokia.widgets.tree.TreeUtils;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;

public class TreeTableModelSorter
extends PTableModelSorter {
    private JTree myTree;
    private Map<TreePath, Integer> myPathToRowMap = new HashMap<TreePath, Integer>();

    public TreeTableModelSorter(TableModel tableModel, JTree tree) {
        super(tableModel);
        this.myTree = tree;
    }

    @Override
    public void sort(boolean switchDirection) {
        this.fireTableWillBeSorted();
        super.sort(switchDirection);
        this.fireTableSorted();
    }

    @Override
    protected PTableModelComparator createComparator(TableModel model) {
        return new TreeTableComparator(model);
    }

    @Override
    protected void clearCachedValues() {
        super.clearCachedValues();
        this.myPathToRowMap.clear();
    }

    private class TreeTableComparator
    extends PTableModelComparator {
        public TreeTableComparator(TableModel model) {
            super(model);
        }

        @Override
        public int compare(Object o1, Object o2) {
            Integer rowForPath2;
            int row1 = (Integer)o1;
            int row2 = (Integer)o2;
            TreePath path1 = TreeTableModelSorter.this.myTree.getPathForRow(row1);
            TreePath path2 = TreeTableModelSorter.this.myTree.getPathForRow(row2);
            if (path1 == null) {
                return path2 != null ? 1 : 0;
            }
            if (path2 == null) {
                return -1;
            }
            if (path2.isDescendant(path1)) {
                return 1;
            }
            if (path1.isDescendant(path2)) {
                return -1;
            }
            int depthOfSharedAncestor = TreeUtils.getDepthOfFirstSharedAncestorNode(path1, path2);
            TreePath path1ToCompare = TreeUtils.getSubPath(path1, depthOfSharedAncestor + 2);
            TreePath path2ToCompare = TreeUtils.getSubPath(path2, depthOfSharedAncestor + 2);
            Integer rowForPath1 = (Integer)TreeTableModelSorter.this.myPathToRowMap.get(path1ToCompare);
            if (rowForPath1 == null) {
                rowForPath1 = TreeTableModelSorter.this.myTree.getRowForPath(path1ToCompare);
                TreeTableModelSorter.this.myPathToRowMap.put(path1ToCompare, rowForPath1);
            }
            if ((rowForPath2 = (Integer)TreeTableModelSorter.this.myPathToRowMap.get(path2ToCompare)) == null) {
                rowForPath2 = TreeTableModelSorter.this.myTree.getRowForPath(path2ToCompare);
                TreeTableModelSorter.this.myPathToRowMap.put(path2ToCompare, rowForPath2);
            }
            if (rowForPath1 >= 0 && rowForPath2 >= 0) {
                return super.compare(rowForPath1, rowForPath2);
            }
            return row1 - row2;
        }
    }
}

