/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.treetable;

import com.nokia.laf.NetTheme;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.table.PSortableTableModel;
import com.nokia.widgets.tree.PTree;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeTableRenderer
extends PTree
implements TableCellRenderer {
    private JTable myTable;
    private int myVisibleRow;
    private boolean myNodeHasFocus;
    private int myVisibleColumn;
    private Color SELECTION_COLOR = new Color(NetTheme.getSelectionColor().getRGB());
    private Color ODD_HOVER_COLOR = new Color(UIManager.getColor("Table.oddHoverBackground").getRGB());
    private Color EVEN_HOVER_COLOR = new Color(UIManager.getColor("Table.evenHoverBackground").getRGB());

    public TreeTableRenderer(TreeModel model, JTable table) {
        super(model);
        this.myTable = table;
        this.putClientProperty("OrangeTouch.hideTreeNodeDashedSeparator", true);
    }

    @Override
    protected void setExpandedState(TreePath path, boolean state) {
        Object oldValue = this.myTable.getClientProperty("OrangeTouch.shouldAdjustSelection");
        this.myTable.putClientProperty("OrangeTouch.shouldAdjustSelection", Boolean.FALSE);
        super.setExpandedState(path, state);
        this.myTable.putClientProperty("OrangeTouch.shouldAdjustSelection", oldValue);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.isControlDown() || e.isShiftDown()) {
            return;
        }
        super.processMouseEvent(e);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.myVisibleRow = row;
        if (table.getModel() instanceof PSortableTableModel) {
            this.myVisibleRow = ((PSortableTableModel)table.getModel()).getOriginalIndex(row);
        }
        this.myNodeHasFocus = hasFocus;
        this.myVisibleColumn = column;
        this.putClientProperty("OrangeTouch.paintedSelectionRow", null);
        if (isSelected) {
            this.setBackground(this.SELECTION_COLOR);
            this.setForeground(table.getSelectionForeground());
            this.putClientProperty("OrangeTouch.paintedSelectionRow", new int[]{row});
        } else if (ComponentUtils.isRolloveredRow(table, row)) {
            this.setBackground(row % 2 == 0 ? this.EVEN_HOVER_COLOR : this.ODD_HOVER_COLOR);
        } else {
            this.setBackground(null);
        }
        return this;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, 0, w, this.myTable.getHeight());
    }

    @Override
    public boolean isRowSelected(int row) {
        int tempRow = row;
        if (this.myTable != null && this.myTable.getModel() instanceof PSortableTableModel) {
            tempRow = ((PSortableTableModel)this.myTable.getModel()).getSortedIndex(tempRow);
        }
        return super.isRowSelected(tempRow);
    }

    @Override
    public void paint(Graphics g) {
        g.translate(0, -this.myVisibleRow * this.getRowHeight() - 1);
        super.paint(g);
        if (this.myNodeHasFocus) {
            int tableRow = this.myTable.getSelectedRow();
            if (tableRow < 0) {
                return;
            }
            Rectangle tableCell = this.myTable.getCellRect(tableRow, this.myVisibleColumn, false);
            int focusRectWidth = tableCell.width;
            Rectangle row = this.getRowBounds(this.myVisibleRow);
            Rectangle adjustedRect = new Rectangle(0, row.y, focusRectWidth - 1, row.height - 1);
            NetUtils.drawFocus((Graphics2D)g, adjustedRect);
        }
    }
}

