/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.treetable;

import com.nokia.widgets.search.SearchEvent;
import com.nokia.widgets.search.SearchListener;
import com.nokia.widgets.table.PSortableTableModel;
import com.nokia.widgets.table.PTableModelSorter;
import com.nokia.widgets.table.TableSortEvent;
import com.nokia.widgets.table.TableSortListener;
import com.nokia.widgets.text.PTextField;
import com.nokia.widgets.text.search.SearchBar;
import com.nokia.widgets.treetable.TreeTable;
import com.nokia.widgets.treetable.TreeTableHighlight;
import com.nokia.widgets.treetable.TreeTableModel;
import com.nokia.widgets.treetable.TreeTableSearchTextField;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableModel;
import javax.swing.text.Position;

public class TreeTableSearchBar
extends SearchBar
implements SearchListener,
PropertyChangeListener {
    private TreeTable myTreeTable;
    protected TreeTableSearchTextField mySearchTextField;
    ListIterator<TreeTableHighlight> mySearchHits;
    private Object myCurrentHighlight = null;
    private TreeModelHandler myTreeModelHandler = new TreeModelHandler();
    private TableSortListener mySortListener = new TableSortHandler();

    public TreeTableSearchBar(TreeTable treeTable) {
        this.myTreeTable = treeTable;
        this.mySearchTextField = new TreeTableSearchTextField(treeTable);
        this.mySearchTextField.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent event) {
                TreeTableSearchBar.this.myCurrentHighlight = null;
                TreeTableSearchBar.this.mySearchHits = null;
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                this.removeUpdate(event);
            }

            @Override
            public void changedUpdate(DocumentEvent event) {
                this.removeUpdate(event);
            }
        });
        treeTable.getTreeModel().addTreeModelListener(this.myTreeModelHandler);
        if (treeTable.getModel() instanceof PTableModelSorter) {
            ((PTableModelSorter)treeTable.getModel()).addTableSortListener(this.mySortListener);
        }
        this.mySearchTextField.addSearchListener(this);
        this.buildUI();
        treeTable.addPropertyChangeListener("model", this);
    }

    public TreeTableSearchTextField getSearchField() {
        return this.mySearchTextField;
    }

    private void clearHighlights() {
        this.myTreeTable.putClientProperty("OrangeTouch.tableEmphasizedHighlight", null);
        this.myTreeTable.putClientProperty("OrangeTouch.highlightText", null);
        this.myTreeTable.getTree().putClientProperty("OrangeTouch.treeEmphasizedHighlight", null);
        this.myTreeTable.getTree().putClientProperty("OrangeTouch.highlightText", null);
    }

    @Override
    public void searchStarted(SearchEvent event) {
        this.mySearchHits = null;
    }

    @Override
    public void searchFinished(SearchEvent event) {
        this.myMatchCount = this.mySearchTextField.getMatches().size();
        this.setSearchButtonsEnabled(this.myMatchCount > 0);
        if (this.mySearchTextField.getText().isEmpty()) {
            this.clearHighlights();
        }
        this.updateMatchesCount();
        this.setPreviousSearchDirection(null);
        this.myTreeTable.repaint();
    }

    @Override
    public void setMaxSearchCount(int maxSearchCount) {
        super.setMaxSearchCount(maxSearchCount);
        this.mySearchTextField.setMaxSearchCount(maxSearchCount);
    }

    public ListIterator<TreeTableHighlight> getSearchHits() {
        return this.mySearchHits;
    }

    public JTree getTree() {
        return this.myTreeTable.getTree();
    }

    private TreeTableHighlight nextBackwardMatch() {
        ListIterator<TreeTableHighlight> searchHits = this.getSearchHits();
        if (searchHits.hasPrevious()) {
            return searchHits.previous();
        }
        List<TreeTableHighlight> matches = this.getSearchField().getMatches();
        this.setSearchHits(matches.listIterator(matches.size()));
        searchHits = this.getSearchHits();
        if (searchHits.hasPrevious()) {
            return searchHits.previous();
        }
        return null;
    }

    private TreeTableHighlight nextForwardMatch() {
        ListIterator<TreeTableHighlight> searchHits = this.getSearchHits();
        if (searchHits.hasNext()) {
            return searchHits.next();
        }
        List<TreeTableHighlight> matches = this.getSearchField().getMatches();
        this.setSearchHits(matches.listIterator());
        searchHits = this.getSearchHits();
        if (searchHits.hasNext()) {
            return searchHits.next();
        }
        return null;
    }

    protected void search(Position.Bias bias) {
        boolean searchDirectionChanged = this.isSearchDirectionChanged(bias);
        this.setPreviousSearchDirection(bias);
        if (this.getSearchHits() == null) {
            this.setSearchHits(this.getSearchField().getMatches().listIterator());
        }
        this.updateEmphasizedMatch(this.getNextMatch(bias, searchDirectionChanged));
    }

    private void setIteratorToCurrentHighlight() {
        if (this.myCurrentHighlight == null || this.mySearchHits == null) {
            return;
        }
        this.myPreviousSearchDirection = Position.Bias.Forward;
        this.mySearchHits = this.getSearchField().getMatches().listIterator();
        while (this.mySearchHits.hasNext()) {
            TreeTableHighlight nextHighlight = this.mySearchHits.next();
            if (!nextHighlight.equals(this.myCurrentHighlight)) continue;
            this.updateEmphasizedMatch(nextHighlight);
            return;
        }
    }

    private void updateEmphasizedMatch(TreeTableHighlight emphasizedMatch) {
        JTree tree = this.myTreeTable.getTree();
        this.myCurrentHighlight = emphasizedMatch;
        if (emphasizedMatch != null && emphasizedMatch.getColumn() == 0) {
            this.myTreeTable.putClientProperty("OrangeTouch.tableEmphasizedHighlight", null);
            tree.putClientProperty("OrangeTouch.treeEmphasizedHighlight", emphasizedMatch);
        } else {
            this.myTreeTable.putClientProperty("OrangeTouch.tableEmphasizedHighlight", emphasizedMatch);
            tree.putClientProperty("OrangeTouch.treeEmphasizedHighlight", null);
        }
        this.scrollMatchToVisible(emphasizedMatch);
        this.myTreeTable.repaint();
    }

    private void scrollMatchToVisible(TreeTableHighlight match) {
        if (match == null) {
            return;
        }
        JTree tree = this.myTreeTable.getTree();
        int row = tree.getRowForPath(match.getPath());
        tree.expandPath(match.getPath().getParentPath());
        if (this.myTreeTable.getModel() instanceof PSortableTableModel) {
            row = ((PSortableTableModel)this.myTreeTable.getModel()).getSortedIndex(row);
        }
        int column = this.myTreeTable.convertColumnIndexToView(match.getColumn());
        this.myTreeTable.scrollRectToVisible(this.myTreeTable.getCellRect(row, column, false));
    }

    private TreeTableHighlight getNextMatch(Position.Bias bias, boolean searchDirectionChanged) {
        if (bias == Position.Bias.Forward) {
            if (searchDirectionChanged) {
                this.nextForwardMatch();
            }
            return this.nextForwardMatch();
        }
        if (searchDirectionChanged) {
            this.nextBackwardMatch();
        }
        return this.nextBackwardMatch();
    }

    public void setSearchHits(ListIterator<TreeTableHighlight> iterator) {
        this.mySearchHits = iterator;
    }

    @Override
    protected void nextMatchAction(ActionEvent e) {
        this.search(Position.Bias.Forward);
    }

    @Override
    protected void previousMatchAction(ActionEvent e) {
        this.search(Position.Bias.Backward);
    }

    @Override
    protected PTextField getPTextField() {
        return this.mySearchTextField;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        TableModel newValue;
        if (!"model".equals(event.getPropertyName())) {
            return;
        }
        TableModel oldValue = (TableModel)event.getOldValue();
        if (oldValue != null) {
            TreeTableModel oldTreeModel = TreeTable.getTreeModel(oldValue);
            oldTreeModel.removeTreeModelListener(this.myTreeModelHandler);
            if (oldValue instanceof PTableModelSorter) {
                ((PTableModelSorter)oldValue).removeTableSortListener(this.mySortListener);
            }
        }
        if ((newValue = (TableModel)event.getNewValue()) != null) {
            TreeTableModel newTreeModel = TreeTable.getTreeModel(newValue);
            newTreeModel.addTreeModelListener(this.myTreeModelHandler);
            if (newValue instanceof PTableModelSorter) {
                ((PTableModelSorter)newValue).addTableSortListener(this.mySortListener);
            }
        }
    }

    private class TableSortHandler
    implements TableSortListener {
        private TableSortHandler() {
        }

        @Override
        public void tableWillBeSorted(TableSortEvent event) {
        }

        @Override
        public void tableSorted(TableSortEvent event) {
            TreeTableSearchBar.this.setIteratorToCurrentHighlight();
        }
    }

    private class TreeModelHandler
    implements TreeModelListener {
        private TreeModelHandler() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            if (!TreeTableSearchBar.this.isUpdateSearchResultsOnModelUpdate() || "".equals(TreeTableSearchBar.this.mySearchTextField.getText())) {
                return;
            }
            TreeTableSearchBar.this.mySearchTextField.search(false);
            TreeTableSearchBar.this.mySearchHits = TreeTableSearchBar.this.mySearchTextField.getMatches().listIterator();
            TreeTableSearchBar.this.setIteratorToCurrentHighlight();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            this.treeNodesChanged(e);
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            this.treeNodesChanged(e);
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            this.treeNodesChanged(e);
        }
    }
}

