/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.treetable;

import com.nokia.widgets.table.PSortableTableModel;
import com.nokia.widgets.table.PTableModelSorter;
import com.nokia.widgets.table.TableSortEvent;
import com.nokia.widgets.table.TableSortListener;
import com.nokia.widgets.tree.AbstractTreeSearchTextField;
import com.nokia.widgets.tree.PreorderNodeIterator;
import com.nokia.widgets.treetable.TreeTable;
import com.nokia.widgets.treetable.TreeTableHighlight;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class TreeTableSearchTextField
extends AbstractTreeSearchTextField
implements TableSortListener {
    protected TreeTable myTreeTable;
    private List<TreeTableHighlight> myMatches = new LinkedList<TreeTableHighlight>();

    public TreeTableSearchTextField(TreeTable treeTable) {
        super(treeTable);
        this.setName("TreeTableSearchTextField");
        this.myTreeTable = treeTable;
        this.myTreeTable.addPropertyChangeListener("model", this);
        if (this.myTreeTable.getModel() instanceof PTableModelSorter) {
            PTableModelSorter newSortModel = (PTableModelSorter)this.myTreeTable.getModel();
            newSortModel.addTableSortListener(this);
        }
    }

    public TreeTable getTreeTable() {
        return this.myTreeTable;
    }

    public List<TreeTableHighlight> getMatches() {
        return this.myMatches;
    }

    @Override
    protected ActionListener createSearchAction() {
        return new SearchAction();
    }

    protected void collectMatches(Iterator<?> nodes, Pattern pattern) {
        this.collectMatches(nodes, pattern, null, true);
    }

    protected void collectMatches(Iterator<?> nodes, Pattern pattern, TreePath toScrollVisible, boolean scrollFirstMatchVisible) {
        String regex = pattern.pattern();
        String unescaped = regex.replaceAll("(\\\\)(\\p{Punct})", "$2");
        JTree tree = this.myTreeTable.getTree();
        TreePath selectionPath = tree.getSelectionPath();
        while (nodes.hasNext()) {
            if (this.myMaxSearchCount != -1 && this.getMatches().size() > this.myMaxSearchCount) break;
            Object nextNode = nodes.next();
            if (!tree.isRootVisible() && this.getParentNode(nextNode) == null) continue;
            TreePath path = this.getPathToRoot(nextNode);
            int row = tree.getRowForPath(path);
            String treeText = this.myTreeTable.convertValueToText(nextNode, tree.isRowSelected(row), tree.isExpanded(row), true, row, 0, false);
            boolean isFirstMatchInNode = true;
            Matcher matcher = pattern.matcher(treeText.toUpperCase());
            while (matcher.find()) {
                if (isFirstMatchInNode) {
                    tree.expandPath(path.getParentPath());
                    isFirstMatchInNode = false;
                    row = tree.getRowForPath(path);
                }
                this.getMatches().add(new TreeTableHighlight(path, unescaped, 0, matcher.start()));
            }
            int column = 1;
            while (column < this.myTreeTable.getColumnCount()) {
                String tableCellText = this.myTreeTable.convertValueToText(nextNode, tree.isRowSelected(row), tree.isExpanded(row), true, row, column, false);
                Matcher tableMatcher = pattern.matcher(tableCellText.toUpperCase());
                while (tableMatcher.find()) {
                    if (isFirstMatchInNode) {
                        tree.expandPath(path.getParentPath());
                        isFirstMatchInNode = false;
                        row = tree.getRowForPath(path);
                    }
                    TreeTableHighlight treeTableHighlight = new TreeTableHighlight(path, unescaped, column, tableMatcher.start());
                    this.getMatches().add(treeTableHighlight);
                }
                ++column;
            }
        }
        this.sortMatchesToViewOrder();
        TreePath pathToScrollVisible = null;
        if (toScrollVisible != null) {
            pathToScrollVisible = toScrollVisible;
        } else if (this.getMatches().size() > 0) {
            TreeTableHighlight firstMatch = this.getMatches().get(0);
            pathToScrollVisible = firstMatch.getPath();
        }
        this.myTreeTable.scrollPathToVisible(pathToScrollVisible);
        if (selectionPath != null) {
            int row = this.myTreeTable.getViewRow(tree.getRowForPath(selectionPath));
            this.myTreeTable.getSelectionModel().addSelectionInterval(row, row);
        }
    }

    public void search(boolean scrollFirstMatchVisible) {
        this.search(null, scrollFirstMatchVisible);
    }

    public void search() {
        this.search(null, true);
    }

    public void search(TreePath toScrollVisible, boolean scrollFirstMatchVisible) {
        this.fireSearchStarted();
        this.myMatches.clear();
        this.myTreeTable.getTree().stopEditing();
        String searchText = this.getText();
        this.myTreeTable.putClientProperty("OrangeTouch.highlightText", searchText);
        this.myTreeTable.getTree().putClientProperty("OrangeTouch.highlightText", searchText);
        if (searchText == null || searchText.length() == 0) {
            this.myTreeTable.repaint();
            this.fireSearchFinished();
            return;
        }
        searchText = searchText.replaceAll("(\\p{Punct})", "\\\\$1");
        Pattern pattern = Pattern.compile(searchText.toUpperCase());
        try {
            this.collectMatches(this.createNodeIterator(), pattern, toScrollVisible, scrollFirstMatchVisible);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.fireSearchFinished();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (!"model".equals(evt.getPropertyName())) {
            return;
        }
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getNewValue();
        if (oldValue instanceof PTableModelSorter) {
            PTableModelSorter oldSortModel = (PTableModelSorter)newValue;
            oldSortModel.removeTableSortListener(this);
        }
        if (newValue instanceof PTableModelSorter) {
            PTableModelSorter newSortModel = (PTableModelSorter)newValue;
            newSortModel.addTableSortListener(this);
        }
        this.sortMatchesToViewOrder();
    }

    private void sortMatchesToViewOrder() {
        PSortableTableModel model = (PSortableTableModel)(this.myTreeTable.getModel() instanceof PSortableTableModel ? this.myTreeTable.getModel() : null);
        Collections.sort(this.getMatches(), new ViewOrderComparator(model));
    }

    protected Iterator<?> createNodeIterator() {
        return new PreorderNodeIterator(this.myTreeTable.getTree().getModel());
    }

    @Override
    public void tableWillBeSorted(TableSortEvent event) {
    }

    @Override
    public void tableSorted(TableSortEvent event) {
        this.sortMatchesToViewOrder();
    }

    public final class SearchAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            TreeTableSearchTextField.this.search();
        }
    }

    private class ViewOrderComparator
    implements Comparator<TreeTableHighlight> {
        private final PSortableTableModel mySortModel;

        public ViewOrderComparator(PSortableTableModel sortModel) {
            this.mySortModel = sortModel;
        }

        @Override
        public int compare(TreeTableHighlight o1, TreeTableHighlight o2) {
            int column2;
            int sortedRow2;
            JTree tree = TreeTableSearchTextField.this.myTreeTable.getTree();
            int row = tree.getRowForPath(o1.getPath());
            int row2 = tree.getRowForPath(o2.getPath());
            int sortedRow = this.mySortModel == null ? row : this.mySortModel.getSortedIndex(row);
            int n = sortedRow2 = this.mySortModel == null ? row2 : this.mySortModel.getSortedIndex(row2);
            if (sortedRow != sortedRow2) {
                return sortedRow - sortedRow2;
            }
            int column = TreeTableSearchTextField.this.myTreeTable.convertColumnIndexToView(o1.getColumn());
            if (column != (column2 = TreeTableSearchTextField.this.myTreeTable.convertColumnIndexToView(o2.getColumn()))) {
                return column - column2;
            }
            return o1.getIndex() - o2.getIndex();
        }
    }
}

