/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.tristatecheckbox;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.widgets.buttons.PCheckBox;
import com.nokia.widgets.icons.PArrowIcon;
import com.nokia.widgets.tristatecheckbox.TristateButtonModel;
import com.nokia.widgets.tristatecheckbox.TristateCheckBoxUI;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.UIManager;

public class TristateCheckBox
extends PCheckBox {
    private Icon myPendingIcon;
    private Icon myRolloverPendingIcon;
    private Icon myDisabledPendingIcon;
    private Icon myFocusedPendingIcon;
    private Icon myFocusedPressedPendingIcon;
    private Icon myPressedPendingIcon;
    private static final String uiClassID = "TristateCheckBoxUI";
    private JPopupMenu myMenu;
    private PArrowIcon myArrowIcon = new PArrowIcon(3, 3, NetLookAndFeel.getBlack());

    static {
        UIManager.put(uiClassID, TristateCheckBoxUI.class.getName());
    }

    public TristateCheckBox(JPopupMenu popupMenu) {
        this(null, null, false);
        this.myMenu = popupMenu;
    }

    public TristateCheckBox() {
        this(null, null, false);
    }

    public TristateCheckBox(Icon icon) {
        this(null, icon, false);
    }

    public TristateCheckBox(Icon icon, boolean selected) {
        this(null, icon, selected);
    }

    public TristateCheckBox(String text) {
        this(text, null, false);
    }

    public TristateCheckBox(Action action) {
        this();
        this.setAction(action);
    }

    public TristateCheckBox(String text, boolean selected) {
        this(text, null, selected);
    }

    public TristateCheckBox(String text, Icon icon) {
        this(text, icon, false);
    }

    public TristateCheckBox(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        this.setModel(new TristateButtonModel());
        this.setSizeVariant("normal");
    }

    public void setPopupMenu(JPopupMenu menu) {
        this.myMenu = menu;
    }

    public JPopupMenu getPopupMenu() {
        return this.myMenu;
    }

    @Override
    protected void processKeyEvent(KeyEvent event) {
        if (this.myMenu != null && (event.getKeyCode() == 121 && event.isShiftDown() || event.getKeyCode() == 525) && this.isEnabled()) {
            JTable table = (JTable)this.getParent();
            if (table == null || !table.isEditing()) {
                return;
            }
            this.myMenu.show(this, this.getWidth() / 2 + 7, this.getHeight() / 2 + 4);
            event.consume();
            return;
        }
        super.processKeyEvent(event);
    }

    @Override
    protected void processMouseEvent(MouseEvent event) {
        if (this.myMenu != null && event.getID() == 501 && this.isEnabled()) {
            Point location = event.getPoint();
            int arrowX = this.getArrowLocationX();
            int arrowY = this.getArrowLocationY();
            int mouseTargetOffset = 3;
            if (location.x > arrowX - mouseTargetOffset && location.x < arrowX + this.myArrowIcon.getIconWidth() + mouseTargetOffset && location.y > arrowY - mouseTargetOffset && location.y < arrowY + this.myArrowIcon.getIconHeight() + mouseTargetOffset) {
                this.myMenu.show(this, this.getWidth() / 2 + 7, this.getHeight() / 2 + 4);
                return;
            }
        }
        super.processMouseEvent(event);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void setUI(TristateCheckBoxUI newUI) {
        super.setUI(newUI);
    }

    @Override
    public void updateUI() {
        this.setUI((TristateCheckBoxUI)UIManager.getUI(this));
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.myMenu != null) {
            this.myArrowIcon.paintIcon(this, graphics, this.getArrowLocationX(), this.getArrowLocationY());
        }
    }

    public void setPendingIcon(Icon icon) {
        Icon oldValue = this.myPendingIcon;
        this.myPendingIcon = icon;
        this.firePropertyChange("selectedIcon", oldValue, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", oldValue, icon);
        }
        if (icon != oldValue && this.isPending()) {
            this.repaint();
        }
    }

    private int getArrowLocationY() {
        return this.getHeight() / 2 - this.myArrowIcon.getIconHeight() / 2;
    }

    private int getArrowLocationX() {
        return this.getWidth() / 2 + 11;
    }

    protected Icon getFocusedPendingIcon() {
        return this.myFocusedPendingIcon;
    }

    protected void setFocusedPendingIcon(Icon icon) {
        Icon oldValue = this.myFocusedPendingIcon;
        this.myFocusedPendingIcon = icon;
        this.firePropertyChange("selectedIcon", oldValue, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", oldValue, icon);
        }
        this.setRolloverEnabled(true);
        if (icon != oldValue && this.isPending() && this.hasFocus()) {
            this.repaint();
        }
    }

    protected Icon getFocusedPressedPendingIcon() {
        return this.myFocusedPressedPendingIcon;
    }

    protected void setFocusedPressedPendingIcon(Icon icon) {
        Icon oldValue = this.myFocusedPressedPendingIcon;
        this.myFocusedPressedPendingIcon = icon;
        this.firePropertyChange("selectedIcon", oldValue, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", oldValue, icon);
        }
        this.setRolloverEnabled(true);
        if (icon != oldValue && this.isPending() && this.isPressed() && this.hasFocus()) {
            this.repaint();
        }
    }

    protected Icon getPressedPendingIcon() {
        return this.myPressedPendingIcon;
    }

    protected void setPressedPendingIcon(Icon icon) {
        Icon oldValue = this.myPressedPendingIcon;
        this.myPressedPendingIcon = icon;
        this.firePropertyChange("selectedIcon", oldValue, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", oldValue, icon);
        }
        this.setRolloverEnabled(true);
        if (icon != oldValue && this.isPending() && this.isPressed()) {
            this.repaint();
        }
    }

    public Icon getPendingIcon() {
        return this.myPendingIcon;
    }

    public void setRolloverPendingIcon(Icon icon) {
        Icon oldValue = this.myRolloverPendingIcon;
        this.myRolloverPendingIcon = icon;
        this.firePropertyChange("selectedIcon", oldValue, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", oldValue, icon);
        }
        this.setRolloverEnabled(true);
        if (icon != oldValue && this.isPending()) {
            this.repaint();
        }
    }

    public Icon getRolloverPendingIcon() {
        return this.myRolloverPendingIcon;
    }

    public void setDisabledPendingIcon(Icon icon) {
        Icon oldValue = this.myDisabledPendingIcon;
        this.myDisabledPendingIcon = icon;
        this.firePropertyChange("selectedIcon", oldValue, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", oldValue, icon);
        }
        if (icon != oldValue && !this.isEnabled() && this.isPending()) {
            this.repaint();
        }
    }

    public Icon getDisabledPendingIcon() {
        if (this.myDisabledPendingIcon == null) {
            if (this.myPendingIcon instanceof ImageIcon) {
                this.myDisabledPendingIcon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)this.myPendingIcon).getImage()));
            } else {
                return this.getDisabledIcon();
            }
        }
        return this.myDisabledPendingIcon;
    }

    public boolean isPending() {
        return ((TristateButtonModel)this.model).isPending();
    }

    public void setPending(boolean b) {
        ((TristateButtonModel)this.model).setPending(b);
    }

    public boolean isPressed() {
        return ((TristateButtonModel)this.model).isPressed();
    }

    @Override
    public void setSizeVariant(String sizeVariant) {
        ImageIcon img = WidgetResources.getImageIcon("TristateCheckBox.Small.Pending.Normal");
        this.setPendingIcon(img);
        img = WidgetResources.getImageIcon("TristateCheckBox.Small.Pending.Disabled");
        this.setDisabledPendingIcon(img);
        img = WidgetResources.getImageIcon("TristateCheckBox.Small.Pending.Rollover");
        this.setRolloverPendingIcon(img);
        img = WidgetResources.getImageIcon("TristateCheckBox.Small.Pending.Focused");
        this.setFocusedPendingIcon(img);
        img = WidgetResources.getImageIcon("TristateCheckBox.Small.Pending.FocusedPressed");
        this.setFocusedPressedPendingIcon(img);
        img = WidgetResources.getImageIcon("TristateCheckBox.Small.Pending.Pressed");
        this.setPressedPendingIcon(img);
        this.putClientProperty("JComponent.sizeVariant", sizeVariant);
    }
}

