/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.util;

import com.nokia.widgets.ClientProperties;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class ClientPropertyUtil {
    public static boolean booleanValue(JComponent component, String key) {
        boolean property = false;
        try {
            Boolean value = (Boolean)component.getClientProperty(key);
            property = value != null && value != false;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return property;
    }

    public static boolean booleanValue(JComponent component, String key, boolean defaultValue) {
        boolean property = defaultValue;
        try {
            Boolean value = (Boolean)component.getClientProperty(key);
            if (value == null) {
                return property;
            }
            property = value != null && value != false;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return property;
    }

    public static boolean hasProperty(JComponent comp, Object key) {
        return comp.getClientProperty(key) != null;
    }

    public static void installProperty(JComponent comp, Object key) {
        if (!ClientPropertyUtil.hasProperty(comp, key)) {
            comp.putClientProperty(key, UIManager.get(key));
        }
    }

    public static int intValue(JComponent component, String key) {
        return ClientPropertyUtil.integerValue(component, key);
    }

    public static Integer integerValue(JComponent component, String key, Integer defaultValue) {
        try {
            Integer value = (Integer)component.getClientProperty(key);
            if (value != null) {
                return value;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return defaultValue;
    }

    public static Integer integerValue(JComponent component, String key) {
        return ClientPropertyUtil.integerValue(component, key, ClientProperties.UNKNOWN_VALUE);
    }
}

