/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.util;

import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.table.PSortableTableModel;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.SystemUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;

public class ComponentUtils {
    private static String ERROR_MESSAGE_LABEL_TYPE = "Given value is not allowed. Valid values are defined in ClienProperties (LABEL_SYSTEM_TEXT, LABEL_TOOLTIP, LABEL_DEFAULT, LABEL_VALUE_TEXT, LABEL_RANGE and LABEL_TITLE";

    public static void setLabelType(Integer type, JComponent comp) {
        ComponentUtils.checkLabelType(type, ERROR_MESSAGE_LABEL_TYPE);
        comp.putClientProperty("labelType", type);
    }

    public static boolean doesIconReferenceImage(Icon icon, Image image) {
        Image iconImage;
        Image image2 = iconImage = icon != null && icon instanceof ImageIcon ? ((ImageIcon)icon).getImage() : null;
        return iconImage == image;
    }

    public static boolean isReadOnly(JComponent comp) {
        return Boolean.TRUE.equals(comp.getClientProperty("OrangeTouch.readOnly"));
    }

    public static boolean isSmall(Component comp) {
        if (comp instanceof JMenuItem) {
            return false;
        }
        if (SystemUtils.isCondensedTheme()) {
            return true;
        }
        return comp instanceof JComponent && "small".equals(((JComponent)comp).getClientProperty("JComponent.sizeVariant"));
    }

    public static boolean isStandalone(JComponent comp) {
        return ClientPropertyUtil.booleanValue(comp, "OrangeTouch.isStandalone", true);
    }

    public static boolean isRounded(JComponent comp) {
        return Boolean.TRUE.equals(comp.getClientProperty("OrangeTouch.roundedOutline"));
    }

    public static boolean isInvalid(JComponent comp) {
        return Boolean.TRUE.equals(comp.getClientProperty("invalidEntry")) && Boolean.TRUE.equals(comp.getClientProperty("OrangeTouch.displayInvalidEntry"));
    }

    public static boolean isRequiredButMissing(JComponent comp) {
        return Boolean.TRUE.equals(comp.getClientProperty("requiredButMissing")) && Boolean.TRUE.equals(comp.getClientProperty("mandatoryEntry"));
    }

    public static boolean containsListener(JComponent comp, Class listenerClass, Object listener) {
        EventListener[] listeners = comp.getListeners(listenerClass);
        int idx = 0;
        while (idx < listeners.length) {
            if (listeners[idx] == listener) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    public static Integer getLabelType(JComponent comp) {
        return ClientPropertyUtil.integerValue(comp, "labelType");
    }

    protected static int checkLabelType(int type, String message) {
        if (type == ClientProperties.LABEL_SYSTEM_TEXT || type == ClientProperties.LABEL_TOOLTIP || type == ClientProperties.LABEL_RANGE || type == ClientProperties.LABEL_DEFAULT || type == ClientProperties.LABEL_VALUE_TEXT || type == ClientProperties.LABEL_TITLE || type == ClientProperties.LABEL_VISUALIZATION_HEADER || type == ClientProperties.LABEL_PRODUCT_NAME || type == ClientProperties.LABEL_HEADER || type == ClientProperties.LABEL_SUB_HEADER || type == ClientProperties.LABEL_TIP_TEXT || type == ClientProperties.LABEL_TIP_LABEL || type == ClientProperties.LABEL_TEXT || type == ClientProperties.LABEL_CALENDAR_DAYS) {
            return type;
        }
        throw new IllegalArgumentException(message);
    }

    public static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    public static int parseAbsoluteTextPosition(Component comp, int position) {
        boolean leftToRight = ComponentUtils.isLeftToRight(comp);
        if (position == 4 || position == 10 && !leftToRight || position == 11 && leftToRight) {
            return 4;
        }
        if (position == 2 || position == 10 && leftToRight || position == 11 && !leftToRight) {
            return 2;
        }
        return 0;
    }

    public static boolean isRolloveredCell(JTable table, int row, int column) {
        Point rolloveredCell = (Point)table.getClientProperty("BlueTouch.rolloveredCell");
        if (rolloveredCell != null) {
            return table.getCellRect(row, column, false).contains(rolloveredCell);
        }
        return false;
    }

    public static boolean isRolloveredRow(JTable table, int row) {
        Point rolloveredCell = (Point)table.getClientProperty("BlueTouch.rolloveredCell");
        if (rolloveredCell != null) {
            Rectangle cellRect = table.getCellRect(row, 0, false);
            cellRect.setBounds(0, (int)cellRect.getY(), table.getWidth(), (int)cellRect.getHeight());
            return cellRect.contains(rolloveredCell);
        }
        return false;
    }

    public static boolean isRolloveredColumn(JTableHeader header, int column) {
        Point rolloverColumn;
        boolean result = false;
        if (header != null && (rolloverColumn = (Point)header.getClientProperty("BlueTouch.rolloveredCell")) != null) {
            result = SystemUtils.isEqual(column, rolloverColumn.getX());
        }
        return result;
    }

    public static boolean isRolloveredRow(JTree tree, int row) {
        Point rolloveredRow = (Point)tree.getClientProperty("BlueTouch.rolloveredCell");
        if (rolloveredRow != null) {
            return row == (int)rolloveredRow.getX() && !tree.isRowSelected(row);
        }
        return false;
    }

    public static boolean isRollovered(JComponent component) {
        Point rollovered = (Point)component.getClientProperty("BlueTouch.rolloveredCell");
        return rollovered != null && rollovered.getX() >= 0.0 && rollovered.getY() >= 0.0 && component.isEnabled();
    }

    public static Component getDeepestAncestorAt(Component c, int x, int y) {
        if (c.contains(x, y)) {
            return c;
        }
        Container parent = c.getParent();
        while (parent != null) {
            Point pointInParent = SwingUtilities.convertPoint(c, x, y, parent);
            if (parent.contains(pointInParent)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static boolean isSortedColumn(PSortableTableModel sortModel, int columnIndex) {
        return columnIndex == sortModel.getSortedColumnIndex() || columnIndex == sortModel.getSecondarySortedColumnIndex() || columnIndex == sortModel.getTertiarySortedColumnIndex();
    }

    public static void highlight(JComponent element, String text) {
        element.putClientProperty("OrangeTouch.highlightText", text);
        Component[] componentArray = element.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component child = componentArray[n2];
            if (child instanceof PLabel) {
                ((PLabel)child).highlight(text);
            } else if (child instanceof JComponent) {
                ComponentUtils.highlight((JComponent)child, text);
            }
            ++n2;
        }
    }
}

